Cette application est un client pour l'API SOAP de 4D, principalement pour accéder au service SOAP S4D.

# Installation

> Attention: cette application ne fonctionne qu'avec Python 3.X

```shell
$ pip install -i http://miroir.blueline.mg/pypi bluebase-services
```

# Configuration

Une fois l'application installée, elle doit être configurée.

La configuration est un fichier de type .INI qui **doit être** placé dans `/etc/bluebase-services/bluebase-services.conf`

```INI
[LOGS]
filename = /var/log/bluebase-services/bluebase-services.log
level = DEBUG

[BLUEBASE-SERVICES]
host = adresse_ip_du_serveur_4D
wsdl = url_du_wsdl_du_service_S4D

[CONTEXT_uncontexte]
ident = username_lié_à_ce_contexte
psw = mot_de_passe_associé
```

Il est possible d'avoir autant de contexte que souhaité afin de permettre à l'application d'endosser le rôle qu'on veut
bien lui prêter.

# Utilisation

## via bluebase_services.core

```python
>>> from bluebase_services.core import Request
>>> request = Request('ussd', 'auth_ussd', version=1)
>>> request.append_data(
...     {
...         'operator': 'bip',
...         'caller_num': '0390390006',
...         'type_num': 'tv_card_num',
...         'login_auth': '2222222222222222',
...         'service_type': 'tv'
...         }
...     )
>>> response = request.send()
```

## via l'API REST

Une interface REST est proposée par l'application.

Vous pouvez la lancer en utilisant le serveur de développement intégré à l'application:

```shell
$ bluebase-services runserver --host 127.0.0.1 --port 5000
```

et en profiter comme suit:

```python
>>> import requests
>>> response = requests.post(
...     url=http://127.0.0.1:5000/api/v1/ussd/auth_ussd,
...     auth=(token,''),
...     json={
...         'operator': 'bip',
...         'caller_num': '0390390006',
...         'type_num': 'tv_card_num',
...         'login_auth': '2222222222222222',
...         'service_type': 'tv'
...         }
...     )
```
