# -*- coding: utf-8 -*-

"""
Ce module propose du matériel permettant de consommer le
contenu de files d'attentes RabbitMQ (donc AMQP) et de
l'exécuter. Il part du principe que ce contenu représente
toujours une requête REST à exécuter.

Les noms des 'bindings' des files d'attentes traitées suivent
la nomenclature 'HTTP_VERB.service'.
"""

import pika
import redis
import threading


class Worker(threading.Thread):
    """Consommateur du contenu d'une file d'attente.
    Supporte le threading"""
    def __init__(self, name, queue, service):
        threading.Thread.__init__(self)
        self.name = name  # le nom du thread (utile pour debug)
        self.queue = queue  # le nom de la file d'attente
        self.service = service  # le nom du service

    def run(self):
        worker(self.queue, self.service)


def worker(queue, service):
    """Fonction de consommation actuelle du contenu de la file d'attente"""
    connection = pika.BlockingConnection(
        pika.ConnectionParameters(
            host='localhost',
            virtual_host='/{}'.format(service)
            )
        )
    channel = connection.channel()

    def callback(ch, method, properties, body):
        """Traduction du document dans la file d'attente en requête
        et exécution"""
        data = eval(body)
        # on évalue un <dict>, pika a du mal si on fait un json.loads(body)
        http_verb = data['method']
        service = data['service']
        version = data['version']
        json_doc = data['json']
        # exécution de la requ^ête représentée dans le <dict>
        from rest_client import RestClient
        client = RestClient(
            'http://localhost/{}-services/api/v{}'.format(service, version)
            )
        action = getattr(client, http_verb.lower())
        result = action(
            data['uri'],
            headers=data['headers'],
            auth=data['auth'],
            params=data['params'],
            data=data['data'],
            json=json_doc
            )
        infos = {
            'status': result['status'],
            'content': result['content']
            }
        key = '{service}:{request_id}'.format(
            service=service,
            request_id=result['headers']['X-Request-Id']
            )
        REDIS_SERVER = redis.Redis()
        REDIS_SERVER.hmset(key, infos)  # on stock le résultat dans redis
        ch.basic_ack(delivery_tag=method.delivery_tag)

    channel.basic_qos(prefetch_count=1)
    channel.basic_consume(callback, queue=queue)
    channel.start_consuming()

# EOF
