# -*- coding: utf-8 -*-

import socket

import redis


__all__ = [
    'API_REGISTRY',
    'HOSTNAME',
    'LDAP_API'
    ]

# récupération du nom de la machine sur laquelle blueflask est exécuté
HOSTNAME = socket.gethostname()

LDAP_API = 'https://api.blueline.mg/ldap/v2'
API_REGISTRY = redis.Redis(host='api.blueline.mg', db=15)

if HOSTNAME.startswith('bldv'):  # si blueflask est sur un serveur de dev
    LDAP_API = 'https://bldv040v.blueline.mg/ldap/v2'
    API_REGISTRY = redis.Redis(db=15)
elif HOSTNAME.startswith('blst'):  # si blueflask est sur un serveur staging
    LDAP_API = 'https://blst040v.blueline.mg/ldap/v2'
    API_REGISTRY = redis.Redis(db=15)

# EOF
