#!/usr/bin/env python
# encoding: utf-8


from .. import card_management, package_management
from . import app

import click
import json


@click.group()
def cmd():
    pass


@cmd.command()
@click.option('--host', default='0.0.0.0')
@click.option('--port', default=5000)
def runserver(host, port):
    """Lancer le serveur Werkzeug pour l'API REST (dev. seulement)"""
    app.run(host=host, port=port, debug=True)


@cmd.command()
def list_stored_cards():
    result = card_management.list_stored_cards()
    click.echo(json.dumps(result, indent=4))


@cmd.command()
def package_and_channel_list():
    result = package_management.package_and_channel_list()
    click.echo(json.dumps(result, indent=4))


@cmd.command()
def package_list():
    result = package_management.package_list()
    click.echo(json.dumps(result, indent=4))


@cmd.command()
@click.argument('artnr')
def list_package_channels(artnr):
    result = package_management.list_package_channels(artnr)
    click.echo(json.dumps(result, indent=4))


@cmd.command()
@click.argument('cardnumber')
def get_card_infos(cardnumber):
    result = card_management.get_card_informations(cardnumber)
    click.echo(json.dumps(result, indent=4))


@cmd.command()
@click.argument('cardnumber')
def list_card(cardnumber):
    result = card_management.list_card(cardnumber)
    click.echo(json.dumps(result, indent=4))


@cmd.command()
@click.argument('cardnumber')
def list_subscription(cardnumber):
    result = card_management.list_subscription(cardnumber)
    click.echo(json.dumps(result, indent=4))


@cmd.command()
@click.argument('cardnumber')
@click.argument('start')
@click.argument('stop')
@click.argument('artnr')
def add_subscription(cardnumber, start, stop, artnr):
    result = card_management.add_subscription(
        cardnumber,
        start,
        stop,
        artnr
        )
    click.echo(json.dumps(result, indent=4))


@cmd.command()
@click.argument('cardnumber')
@click.argument('stop')
@click.argument('artnr')
def stop_subscription(cardnumber, stop, artnr):
    result = card_management.stop_subscription(cardnumber, stop, artnr)
    click.echo(json.dumps(result, indent=4))


@cmd.command()
@click.argument('cardnumber')
@click.argument('start')
@click.argument('stop')
@click.argument('artnr')
def start_subscription(cardnumber, start, stop, artnr):
    result = card_management.start_subscription(
        cardnumber,
        start,
        stop,
        artnr
        )
    click.echo(json.dumps(result, indent=4))


@cmd.command()
@click.argument('cardnumber')
@click.argument('irdnumber')
def pair_card(cardnumber, irdnumber):
    result = card_management.pair_card(cardnumber, irdnumber)
    click.echo(json.dumps(result, indent=4))


@cmd.command()
@click.argument('cardnumber')
def unpair_card(cardnumber):
    result = card_management.un_pair_card(cardnumber)
    click.echo(json.dumps(result, indent=4))


if __name__ == '__main__':
    cmd()

# EOF
