# -*- utf-8 -*-

from to_log import Logger

import configparser
import socket

import redis


__all__ = [
    'ADDRESS',
    'APIGW',
    'CONFIG',
    'ERRORS',
    'HOSTNAME',
    'HTTP_ERRORS',
    'LOGS',
    'REDIS_DB',
    'SERVICE_CODE',
    ]

CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/cryptoguard-services/cryptoguard-services.conf')

SERVICE_CODE = CONFIG['APP']['service_code']
HOSTNAME = socket.gethostname()
_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
_socket.connect(("41.204.103.205", 80))
ADDRESS = _socket.getsockname()[0]
REDIS_DB = redis.Redis()

if HOSTNAME.startswith('bldv'):
    APIGW = 'bldv040v.blueline.mg'
elif HOSTNAME.startswith('blst'):
    APIGW = 'blst040v.blueline.mg'
else:
    APIGW = 'api.blueline.mg'
    REDIS_DB = redis.Redis(db=int(SERVICE_CODE.split('-')[1]))

LOG_FILE = CONFIG['LOGS']['filename']
LOG_LEVEL = CONFIG['LOGS']['level']

LOGS = Logger('cryptoguard-services', level=LOG_LEVEL)
LOGS.set_file_handler(LOG_FILE)

HTTP_ERRORS = {
    '400': 'la syntaxe de la requête est erronée',
    '401': 'authentification incorrecte',
    '403': 'accès non autorisé',
    '404': 'ressource non trouvée',
    '405': 'méthode non autorisée',
    '409': 'conflit',
    '410': 'ressource disparue',
    '412': 'pré-conditions non vérifiées',
    '500': 'erreur interne au serveur',
    '503': 'service indisponible'
    }

ERRORS = {}
for section in [i for i in CONFIG.sections() if i.startswith('Error_')]:
    for key, value in CONFIG[section].items():
        code = section.split('_')[1]
        ERRORS[key] = {
            'error':  HTTP_ERRORS[code],
            'message': {'error': value},
            'code': '{}-{}'.format(SERVICE_CODE, key),
            'status': int(code)
            }
# EOF
