# -*- utf-8 -*-

"""
Ce module contient toutes les méthodes permettant de gérer
les packages d'une carte TV Cryptoguard
"""

from collections import OrderedDict

from .core import cryptoguard_command

__all__ = [
    'list_package_channels',
    'package_and_channel_list',
    'package_list'
    ]


@cryptoguard_command()
def package_and_channel_list(**kwargs):
    """Retourne la liste des packages et des chaines qu'elles contiennent"""
    result = kwargs['result']
    channel_packages = result['message']['ChannelPackage']
    channel_packages = [
        {
            'id': channel_package['@ArtNr'],
            'name': channel_package['@Name'],
            'channels': channel_package.get('Channel', [])
            }
        for channel_package in channel_packages
        ]
    for channel_package in channel_packages:
        channels = channel_package['channels']
        if isinstance(channels, OrderedDict):
            channels = [channels]
        channels = [
            {
                'id': channel['@ChannelID'],
                'name': ' '.join(channel['@ChannelName'].split()[:-1]),
                'service-id': channel['@ChannelName'].split()[-1].replace(
                    '(', '').replace(
                        ')', '')
                }
            for channel in channels
            ]
        channel_package['channels'] = channels
    result['message'] = channel_packages
    return result


@cryptoguard_command()
def package_list(**kwargs):
    """Retourne la liste des packages configurés dans le CAS"""
    result = kwargs['result']
    packages = result['message'].get('ChannelPackage', [])
    packages = [
        {
            'id': package['@ArtNr'],
            'name': package['@Name']
            }
        for package in packages
        ]
    result['message'] = packages
    return result


@cryptoguard_command('artnr')
def list_package_channels(artnr, **kwargs):
    """Retourne la liste des chaines contenues dans un package"""
    result = kwargs['result']
    channels = result['message'].get('Channel', [])
    if isinstance(channels, OrderedDict):
        channels = [channels]
    channels = [
        {
            'id': channel['@ChannelID'],
            'name': ' '.join(channel['@ChannelName'].split()[:-1]),
            'service-id': channel['@ChannelName'].split()[-1].replace(
                '(', '').replace(
                    ')', '')
            }
        for channel in channels
        ]
    result['message'] = {
        'artnr': artnr,
        'channels': channels
        }
    return result

# EOF
