#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Ce module contient les fonctions de tests pour les commandes
liées à la gestion de cartes TV.
Il requiert que l'application cryptoguard_services soit déjà installée
"""

from datetime import datetime

from cryptoguard_services import SERVICE_CODE
from cryptoguard_services import add_subscription
from cryptoguard_services import invalidate_card
from cryptoguard_services import list_card
from cryptoguard_services import list_subscription
from cryptoguard_services import revalidate_card
from cryptoguard_services import stop_subscription

import unittest

CODE = '{SERVICE_CODE}-'.format(SERVICE_CODE=SERVICE_CODE)


class TestCardManagementCommands(unittest.TestCase):

    def test_list_card(self):
        result = list_card('00043101000128')
        assert isinstance(result, dict)
        self.assertEqual(result['code'], CODE+'0')

    def test_list_card_with_wrong_number(self):
        result = list_card('00043101000')
        assert isinstance(result, dict)
        self.assertEqual(result['code'], CODE+'4')

    def test_list_subscription(self):
        result = list_subscription('00043101000128')
        assert isinstance(result, dict)
        self.assertEqual(result['code'], CODE+'0')

    def test_add_subscription(self):
        result = add_subscription(
            '00043101000128',
            datetime.now().date().strftime('%Y-%m-%d'),
            '2030-12-31',
            '10'
            )
        self.assertEqual(result['code'], CODE+'11')  # abonnement déjà présent
        result = add_subscription(
            '00043101000128',
            datetime.now().date().strftime('%Y-%m-%d'),
            '2030-12-31',
            '11'
            )
        self.assertEqual(result['code'], CODE+'11')  # abonnement déjà présent
        result = add_subscription(
            '00043101000128',
            datetime.now().date().strftime('%Y-%m-%d'),
            '2030-12-31',
            '12'
            )
        self.assertEqual(result['code'], CODE+'0')

    def test_stop_subscription(self):
        result = stop_subscription(
            '00043101000128',
            datetime.now().date().strftime('%Y-%m-%d'),
            '12'
            )
        self.assertEqual(result['code'], CODE+'0')
        result = stop_subscription(
            '00043101000128',
            datetime.now().date().strftime('%Y-%m-%d'),
            '12'
            )
        self.assertEqual(result['code'], CODE+'20')

    def test_invalidate_revalidate_card(self):
        result = invalidate_card('00043101000128')
        self.assertEqual(result['code'], CODE+'0')
        result = list_card('00043101000128')
        self.assertEqual(result['code'], CODE+'37')
        result = revalidate_card('00043101000128')
        self.assertEqual(result['code'], CODE+'0')


if __name__ == '__main__':
    unittest.main()
