#!/usr/bin/env python
# encoding: utf-8


from setuptools import setup, find_packages

setup(
    name="dvbbox",
    version='3.0.1',
    packages=find_packages(),
    author="Blueline Madagascar",
    author_email="dev@si.blueline.mg",
    license="MIT",
    install_requires=[
        'click==8.0.1',
        'pika==1.2.0',
        'pyyaml==5.4.1',
        'records==0.5.3',
        'redis==3.5.3',
        'requests==2.25.1',
        'systemd-python==234',
        'xmltodict==0.12.0',
        'blueflask==2.0',
        'to-log==0.2'
        ],
    include_package_data=True,
    entry_points={
        'console_scripts': [
            'dvbbox=dvbbox.api.cli:cmd',
            ],
        }
    )
