#!/usr/bin/env python
# encoding: utf-8

"""
Ce module permet de manipuler les chaines présentes sur le réseau
Blueline TV.

La liste des chaines, ainsi que leurs noms, est disponible via
l'API REST de monitoring-dvb.
"""

from rest_client import RestClient

from .consts import CACHE, CONFIG


__all__ = [
    'Channel',
    ]


class Channel(object):
    """Représente une chaine sur le réseau Blueline TV"""

    def __init__(self, service_id):
        self.service_id = service_id
        if self.service_id in CACHE:
            for key, value in CACHE[self.service_id].items():
                setattr(self, key, value)
            try:
                config_infos = CONFIG['CHANNEL_{}'.format(self.service_id)]
            except KeyError:
                pass
            else:
                for key, value in config_infos.items():
                    setattr(self, key, value)
        else:
            client = RestClient(CONFIG['URLS']['services'])
            infos = client.get('/{}'.format(self.service_id))
            if infos['status'] == 200:
                self.name = infos['content']['name']
                # self.frequency = infos['content']['frequency']
                try:
                    config_infos = CONFIG['CHANNEL_{}'.format(self.service_id)]
                except KeyError:
                    pass
                else:
                    for key, value in config_infos.items():
                        setattr(self, key, value)
                CACHE[self.service_id] = self.__dict__
            else:
                raise SystemError(infos['content'])

    def __repr__(self):
        return '<Channel {service_id}:{name}>'.format(
            service_id=self.service_id,
            name=self.name
            )

    @staticmethod
    def search(name):
        """Rechercher une chaine par nom"""
        client = RestClient(CONFIG['URLS']['services'])
        infos = client.get('', params={'name': name})
        if infos['status'] == 200:
            return infos['content']['services']

    @staticmethod
    def get(name):
        result = Channel.search(name)
        if len(result) == 1:
            return Channel(result[0]['service_id'])

    @staticmethod
    def all():
        client = RestClient(CONFIG['URLS']['services'])
        infos = client.get('')
        if infos['status'] == 200:
            for service in infos['content']['services']:
                yield Channel(service['service_id'])


# EOF
