#!/usr/bin/env python
# encoding: utf-8

from email.mime.multipart import MIMEMultipart
from email.mime.base import MIMEBase
from email.mime.text import MIMEText
from multiprocessing.pool import Pool

from ..consts import CONFIG
from .. import core
from ..product import Product
from . import app

import click
import smtplib
import tablib


@click.group()
def cmd():
    pass


@cmd.command()
@click.option('--host', default='0.0.0.0')
@click.option('--port', default=5000)
def runserver(host, port):
    app.run(host=host, port=port, debug=True)


@cmd.command()
def sync():

    products = Product.all()
    for product in products:
        product.update_customers()
        with Pool(4) as pool:
            pool.map(core.update_customer_cdr, product.customers)


@cmd.command()
@click.option('--append_details', is_flag=True, default=False)
@click.option('--for_real', is_flag=True, default=False)
@click.option('--send_mail', is_flag=True, default=False)
def apply(append_details, for_real, send_mail):

    result = {}
    products = Product.all()
    for product in products:
        policies = product.apply_policies(
            for_real=for_real
            )
        if policies:
            result[product.name] = policies
    if result:
        message = ''
        dataset = tablib.Dataset()
        dataset.headers = [
            'product',
            'data_limit',
            'policy_name',
            'customer',
            'download',
            'upload',
            'total'
            ]
        products = sorted([i for i in result], reverse=True)
        for product in products:
            policies = result[product]
            message += 'Produit: {product}\n'.format(product=product)
            for policy in policies:
                message += (
                    '\n'
                    'Limite autorisée: {data_limit} Go\n'
                    ).format(
                        data_limit=policy['data_limit']
                        )
                foo = ''
                for customer, data in policy['customers'].items():
                    dataset.append(
                        [
                            product,
                            policy['data_limit'],
                            policy['name'],
                            customer,
                            data['octets_in'],
                            data['octets_out'],
                            data['total']
                            ]
                        )
                    if data.get('fup_in'):
                        status = 'fup_in'
                    elif data.get('fup_out'):
                        status = 'fup_out'
                    else:
                        status = None
                    if status:
                        foo += (
                            ' - {customer}: {total} Go ({status})\n'.format(
                                customer=customer,
                                total=data['total'],
                                status=status
                                )
                            )
                if foo:
                    message += foo
                else:
                    message += "Aucun client à FUPer\n"
            message += '\n\n\n'
        click.echo(message)
        with open('/tmp/details.csv', 'w') as f:
            f.write(dataset.export('csv'))
        if send_mail:
            recipients = CONFIG['ALERT']['to']
            content = MIMEText(message, 'plain', 'utf-8')
            attachment = MIMEBase('text', 'csv')
            fp = open('/tmp/details.csv', 'rb')
            attachment.set_payload(fp.read())
            fp.close()
            attachment.add_header(
                'Content-Disposition',
                'attachment',
                filename='details.csv'
                )
            msg = MIMEMultipart('alternative')
            msg['Subject'] = CONFIG['ALERT']['subject']
            msg['From'] = CONFIG['ALERT']['from']
            msg['To'] = recipients
            msg.attach(attachment)
            msg.attach(content)
            s = smtplib.SMTP('localhost')
            s.sendmail(
                CONFIG['ALERT']['from'],
                recipients.replace(' ', '').split(','),
                msg.as_string()
                )
            s.quit()

# EOF
