# -*- coding: utf-8 -*-


"""
Init values
"""

from rest_client import RestClient
from to_log import Logger

import configparser
import socket

import redis


__all__ = [
    'ADDRESS',
    'AIGUILLIER_URL',
    'AIGUILLIER_USERNAME',
    'APIGW',
    'CONFIG',
    'DAYS',
    'FUPDB_CREDENTIALS',
    'HOSTNAME',
    'LOGS',
    'REDIS_DB',
    'REST_CLIENT',
    'SERVICE_CODE',
    ]

CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/fup-services/fup-services.conf')  # CONFIG file

DAYS = [
    None,
    'Lundi',
    'Mardi',
    'Mercredi',
    'Jeudi',
    'Vendredi',
    'Samedi',
    'Dimanche'
    ]

AIGUILLIER_URL = CONFIG['AIGUILLIER']['url']
AIGUILLIER_USERNAME = CONFIG['AIGUILLIER']['username']

SERVICE_CODE = CONFIG['APP']['service_code']
HOSTNAME = socket.gethostname().split('.')[0]
_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
_socket.connect(("41.204.103.205", 80))
ADDRESS = _socket.getsockname()[0]
REDIS_DB = redis.Redis()

if HOSTNAME.startswith('bldv'):
    APIGW = 'bldv040v.blueline.mg'
elif HOSTNAME.startswith('blst'):
    APIGW = 'blst040v.blueline.mg'
else:
    APIGW = 'api.blueline.mg'
    REDIS_DB = redis.Redis(db=int(SERVICE_CODE.split('-')[1]))

LOG_LEVEL = CONFIG['LOGS']['level']
LOG_FILE = CONFIG['LOGS']['filename']

LOGS = Logger('fup-services')
LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

API_LOGS = Logger('fup-services-api')
API_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

BLUEFLASK_LOGS = Logger('blueflask')
BLUEFLASK_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

REST_CLIENT_LOGS = Logger('rest_client')
REST_CLIENT_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

FUPDB_CREDENTIALS = {
    key: CONFIG['DB'][key]
    for key in CONFIG.options('DB')
    }

REST_CLIENT = RestClient(AIGUILLIER_URL)

# EOF
