# -*- coding: utf-8 -*-


"""
Init values
"""

from rest_client import RestClient
from to_log import Logger

import configparser
import socket

import redis


__all__ = [
    'ADDRESS',
    'AIGUILLIER_URL',
    'AIGUILLIER_USERNAME',
    'APIGW',
    'CONFIG',
    'DAYS',
    'FUPDB_CREDENTIALS',
    'HOSTNAME',
    'LOGS',
    'RAPPORT_HTML',
    'REDIS_DB',
    'REST_CLIENT',
    'SERVICE_CODE',
    ]

CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/fup-services/fup-services.conf')  # CONFIG file

DAYS = [
    None,
    'Lundi',
    'Mardi',
    'Mercredi',
    'Jeudi',
    'Vendredi',
    'Samedi',
    'Dimanche'
    ]

AIGUILLIER_URL = CONFIG['AIGUILLIER']['url']
URL_V2 = CONFIG['AIGUILLIER']['url_v2']
AIGUILLIER_USERNAME = CONFIG['AIGUILLIER']['username']

SERVICE_CODE = CONFIG['APP']['service_code']
HOSTNAME = socket.gethostname().split('.')[0]
_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
_socket.connect(("41.204.103.205", 80))
ADDRESS = _socket.getsockname()[0]
REDIS_DB = redis.Redis()

if HOSTNAME.startswith('bldv'):
    APIGW = 'bldv040v.blueline.mg'
elif HOSTNAME.startswith('blst'):
    APIGW = 'blst040v.blueline.mg'
else:
    APIGW = 'api.blueline.mg'
    REDIS_DB = redis.Redis(db=int(SERVICE_CODE.split('-')[1]))

LOG_LEVEL = CONFIG['LOGS']['level']
LOG_FILE = CONFIG['LOGS']['filename']

LOGS = Logger('fup-services')
LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

API_LOGS = Logger('fup-services-api')
API_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

BLUEFLASK_LOGS = Logger('blueflask')
BLUEFLASK_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

REST_CLIENT_LOGS = Logger('rest_client')
REST_CLIENT_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

FUPDB_CREDENTIALS = {
    key: CONFIG['DB'][key]
    for key in CONFIG.options('DB')
    }

REST_CLIENT = RestClient(AIGUILLIER_URL)

RAPPORT_HTML = """
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8"/>
  </head>
  <h2>Rapport FUP</h2>
  {% for product, policies in result.items() %}
  <p>
    <h3>Produit: {{ product }}</h3>
    {% for policy in policies %}
    {% set flag = False %}
    <p>
      <h4>Limite autorisée: {{ policy.data_limit }} Go</h4>
        <ul>
          {% for customer, data in policy.customers.items() %}
          {% if data.fup_in %}
          <li>
            {{ customer }}: {{ data.total }} Go (fup_in)
          </li>
          {% elif data.fup_out %}
          <li>
            {{ customer }}: {{ data.total }} Go (fup_out)
          </li>
          {% endif %}
          {% endfor %}
        </ul>
    </p>
    {% endfor %}
  </p>
  {% endfor %}

  <h2>Statistiques de restrictions/libérations du jour</h2>
  <p>
    <table border="1">
      <tr>
        <th>Produit</th>
        <th>Débit restreint</th>
        <th>Débit rétabli</th>
      </tr>
      {% for row in stats %}
      <tr>
        <td>{{ row.0 }}</td>
        <td>{{ row.1 }}</td>
        <td>{{ row.2 }}</td>
      </tr>
      {% endfor %}
    </table>
  </p>
  <h2>Synthèse</h2>
  <p>
    <table border="1">
      <tr>
        <th>Politique</th>
        <th>Produit</th>
        <th>Débit normal</th>
        <th>Débit restreint</th>
        <th>Total</th>
        <th>Pourcentage restreint</th>
      </tr>
      {% for row in synthesis %}
      <tr>
        <td>{{ row.0 }}</td>
        <td>{{ row.1 }}</td>
        <td>{{ row.2 }}</td>
        <td>{{ row.3 }}</td>
        <td>{{ row.4 }}</td>
        <td>{{ row.5 }}</td>
      </tr>
      {% endfor %}
    </table>
  </p>
</html>
"""

# EOF
