#!/usr/bin/env python
# encoding: utf-8

from pytz import timezone
from to_log import Logger  # NOQA
import configparser
import socket
import redis
import pika


# utiliser rabbitmq pour la gestion des requêtes
# en asynchrone

connection = pika.BlockingConnection(
    pika.ConnectionParameters(
        host="localhost",
        virtual_host="/gpstracker"
    )
)
# definition du channel et de l'exchange à utiliser sur rabbitmq
channel = connection.channel()
channel.exchange_declare(exchange="gps_tracker", exchange_type="topic")
# definition du queue
channel.queue_declare(
    queue="gps.tracker",
    durable="True"
    )
# definition bind
channel.queue_bind(
    exchange="gps_tracker",
    queue="gps.tracker",
    routing_key="gps_msg"
    )
connection.close()

CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read("/etc/gps-services/gps-services.conf")
TZ = timezone('Indian/Antananarivo')
USE_I18N = True
USE_L10N = True
USE_TZ = True
SERVICE_CODE = CONFIG["APP"]["service_code"]
GUNICORN_PORT = int(SERVICE_CODE[1:].replace("-", ""))
HOSTNAME = socket.gethostname().split(".")[0]
REDIS = redis.Redis(db=7)
_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
_socket.connect(("41.204.103.205", 80))
ADDRESS = _socket.getsockname()[0]
API_REGISTRY = redis.Redis(db=15)

if HOSTNAME.startswith("bldv"):
    APIGW = "bldv040v.blueline.mg"
elif HOSTNAME.startswith("blst"):
    APIGW = "blst040v.blueline.mg"
else:
    APIGW = "api.blueline.mg"
    API_REGISTRY = redis.Redis(host=APIGW, db=15)

LOG_FILE = CONFIG["LOGS"]["filename"]
LOG_LEVEL = CONFIG["LOGS"]["level"]
LOGS = Logger("gps-services")
LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)
API_LOGS = Logger("pgs-services-api")
API_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)
UDP = CONFIG["UDP"]

TRACKS_MODEL = {
    '__tablename__': 'gpstracks',
    'id': {'type': 'Integer', 'pk': True},
    'imei': {'type': 'String(15)'},
    'datetime': {'type': 'DateTime(timezone=True)'},
    'longitude': {'type': 'Numeric(9,7)'},
    'latitude': {'type': 'Numeric(9,7)'},
    'angle': {'type': 'Float'},
    'speed': {'type': 'Float'}
    }

# EOF
