#!/usr/bin/env python
# encoding: utf-8


"""
Command Line Interface
"""

import click
# import socket
# import threading
import socketserver
from . import app
from .. import UDP
from ..worker import process, Worker
from ..udpserver import ThreadedUDPRequestHandler  # , ThreadedUDPServer


@click.group()
def cmd():
    pass


@cmd.command()
@click.argument('queue')
@click.option('--workers', type=int, default=1)
def async_daemon(queue, workers):
    """Lance un ou plusieurs workers pour une file d'attente"""

    if not workers:
        click.echo("il me faut au moins un worker")
    elif workers == 1:
        process(queue)
    else:
        threads = [
            Worker('worker-{}'.format(i), queue)
            for i in range(workers)
        ]
        for thread in threads:
            thread.start()


@cmd.command()
@click.option('--host', default='127.0.0.1')
@click.option('--port', default=5000)
def runserver(host, port):
    app.run(host=host, port=port, debug=True)


@cmd.command()
def udpserver():
    """Lancer le serveur de récupération de traces"""
    server = socketserver.UDPServer(
        ("0.0.0.0", 3112),
        ThreadedUDPRequestHandler
        )
    server.serve_forever()

# EOF
