#!/usr/bin/env python
# encoding: utf-8

import pika
import threading
from .core import Parser


def process(queue):
    """ Traitement des files d'attentes """
    connection = pika.BlockingConnection(
        pika.ConnectionParameters(host="localhost", virtual_host="/gpstracker")
    )

    channel = connection.channel()
    channel.basic_consume(callback, queue=queue)
    channel.start_consuming()


class Worker(threading.Thread):
    def __init__(self, name, arg):
        threading.Thread.__init__(self)
        self.name = name
        self.arg = arg

    def run(self):
        process(self.arg)


def callback(ch, method, headers, body):
    tracks = Parser(body)
    tracks.parse()
    ch.basic_ack(delivery_tag=method.delivery_tag)

# EOF
