#!/usr/bin/env python
# encoding: utf-8


from setuptools import setup, find_packages

setup(
    name="gps-services",
    version='1.0.1',
    packages=find_packages(),
    author="Blueline Madagascar",
    author_email="dev@si.blueline.mg",
    license="MIT",
    install_requires=[
        "click==6.7",
        "pika==0.11.2",
        "blueflask==1.1",
        "rest-client==0.2",
        "records==0.5.2",
        "psycopg2==2.7.3.2",
        "redis==2.10.6",
        "ipython==6.2.1",
        "pytz==2018.4",
        ],
    include_package_data=True,
    entry_points={
        'console_scripts': [
            'gps-services=gps_services.api.cli:cmd',
            ]
        }
    )

# EOF
