# -*- coding: utf-8 -*-

from blueflask.lib.decorators import auth as ldap

from . import api


@api.route('/simboxes', methods=['PUT'])
@ldap.login_required
def manage_simbox():
    """
    Block or unblock a simbox using its IMSI or its ISDN.
    Submit a form with a status and a parameter (ISDN or IMSI),
    from which the endpoint will decide to block or unblock a simbox
    ---
    tags:
      - Simboxes
    components:
      securitySchemes:
        basicAuth:
          type: http
          scheme: basic
    security:
      - basicAuth: []
    parameters:
      - name: Simbox management form
        in: body
        required: true
        schema:
          id: Simbox management
          properties:
            imsi:
              type: string
              description: simbox's imsi
            isdn:
              type: string
              description: simbox's isdn
            status:
              type: boolean
              description: block or unblock simbox
    responses:
      500:
        description: internal error
      401:
        description: your token is invalid
      404:
        description: could not find the simbox
      204:
        description: the request went fine
    """
    pass
