# -*- coding: utf-8 -*-

from to_log import Logger

import configparser
import socket


__all__ = [
    'ADDRESS',
    'APIGW',
    'CONFIG',
    'HOSTNAME',
    'LOGS',
    'SERVICE_CODE'
    ]


CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/hlr-services/hlr-services.conf')

SERVICE_CODE = CONFIG['APP']['service_code']
HOSTNAME = socket.gethostname().split('.')[0]
_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
_socket.connect(("41.204.103.205", 80))
ADDRESS = _socket.getsockname()[0]
if HOSTNAME.startswith('bldv'):
    APIGW = 'bldv040v.blueline.mg'
elif HOSTNAME.startswith('blst'):
    APIGW = 'blst040v.blueline.mg'
else:
    APIGW = 'api.blueline.mg'

LOG_LEVEL = CONFIG['LOGS']['level']
LOG_FILE = CONFIG['LOGS']['filename']

LOGS = Logger('hlr-services')
LOGS.set_file_handler(filename=LOG_FILE, level=LOG_LEVEL)

API_LOGS = Logger('hlr-services-api')
API_LOGS.set_file_handler(filename=LOG_FILE, level=LOG_LEVEL)

BLUEFLASK_LOGS = Logger('blueflask')
BLUEFLASK_LOGS.set_file_handler(filename=LOG_FILE, level=LOG_LEVEL)

REST_CLIENT_LOGS = Logger('rest_client')
REST_CLIENT_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

# EOF
