# HLR

API permettant d'interagir avec le HLR

## Configuration

Il faut disposer d'un fichier de configuration `/etc/hlr-services/hlr-services.conf`:

```INI
[HLR]
host = hlr_telnet_host
port = hlr_telnet_port
username = username
password = password
timeout = telnet_connection_timeout

[LOGS]
filename = /path/to/logs
level = INFO
```

## Installation

```
$ [sudo] pip3 install -i http://miroir.blueline.mg/pypi hlr-services
```

## Déploiement

### En mode dev

```
$ hlr-services runserver --host 127.0.0.1 --port 5000
```

### Avec gunicorn

```
$ gunicorn -b 127.0.0.1:5000 --log-level debug --preload hlr-services.api:app
```

## Documentation

Une fois déployée:

 * les specifications de l'API se trouvent sous `/api/spec` (OpenAPI specs)
 * la documentation de l'API se trouve à la racine: `/apidoc` (Swagger UI)
