#!/usr/bin/env python
# encoding: utf-8

from .core import Client
from .consts import LOGS, SERVICE_CODE, CONFIG

import threading

import json
import pika


def process(telnet_client, url_smsc, queue):
    """Traitement des files d'attentes"""

    def callback(ch, method, properties, body):

        def activate_lte(apntplid, imsi, tplid):
            LOGS.logger.info('activate_lte {}-{}-{}'.format(
                apntplid,
                tplid,
                imsi
                ))
            try:
                telnet_client.update_tplgprs_profile_3g(
                    imsi,
                    tplid
                    )
                code = telnet_client.response['code']
                if not code:
                    telnet_client.update_eps_profile_lte(imsi)
                    code = telnet_client.response['code']
                    if not code:
                        telnet_client.update_optgprs_profile_lte(
                            imsi
                            )
                        code = telnet_client.response['code']
                        if not code:
                            LOGS.logger.info('x: {}'.format(
                                code
                                ))
                            telnet_client.update_optgprs_profile_lte_confirm(
                                imsi,
                                apntplid,
                                tplid
                                )
                            code = telnet_client.response['code']
            except Exception as exc:
                LOGS.logger.error(exc)
                ch.basic_publish(
                    exchange='sendcmd',
                    routing_key=queue,
                    body=json.dumps(document),
                    properties=pika.BasicProperties(
                        delivery_mode=2
                        )
                    )
            else:
                message = telnet_client.response['message']
                return_code = '{service_code}-{code}'.format(
                    service_code=SERVICE_CODE,
                    code=code
                    )
                if code:
                    msg = {
                        'status': 500,
                        'error': 'erreur interne',
                        'code': return_code,
                        'message': message
                        }
                    LOGS.logger.error(msg)
                else:
                    LOGS.logger.info(message)
                ch.basic_ack(delivery_tag=method.delivery_tag)

        def activate_3g(imsi, tplid):
            LOGS.logger.info('activate_3g {}-{}'.format(
                tplid,
                imsi
                ))
            try:
                telnet_client.update_tplgprs_profile_3g(
                    imsi,
                    tplid
                    )
            except Exception as exc:
                LOGS.logger.error(exc)
                ch.basic_publish(
                    exchange='sendcmd',
                    routing_key=queue,
                    body=json.dumps(document),
                    properties=pika.BasicProperties(
                        delivery_mode=2
                        )
                    )
            else:
                code = telnet_client.response['code']
                message = telnet_client.response['message']
                return_code = '{service_code}-{code}'.format(
                    service_code=SERVICE_CODE,
                    code=code
                    )
                if code:
                    msg = {
                        'status': 500,
                        'error': 'erreur interne',
                        'code': return_code,
                        'message': message
                        }
                    LOGS.logger.error(msg)
                else:
                    LOGS.logger.info(message)
                ch.basic_ack(delivery_tag=method.delivery_tag)

        def desactivate_lte(imsi):
            LOGS.logger.info('desactivate_lte {}'.format(
                imsi
                ))
            try:
                telnet_client.desactivate_eps_profile_lte(
                    imsi
                    )
                code = telnet_client.response['code']
                if not code or code == 3015:
                    telnet_client.desactivate_optgprs_profile_lte(
                        imsi
                        )
                    code = telnet_client.response['code']
                    if not code:
                        telnet_client.desactivate_gprs_profile_lte(
                            imsi
                            )
                        code = telnet_client.response['code']
            except Exception as exc:
                LOGS.logger.error(exc)
                ch.basic_publish(
                    exchange='sendcmd',
                    routing_key=queue,
                    body=json.dumps(document),
                    properties=pika.BasicProperties(
                        delivery_mode=2
                        )
                    )
            else:
                message = telnet_client.response['message']
                return_code = '{service_code}-{code}'.format(
                    service_code=SERVICE_CODE,
                    code=code
                    )
                if code:
                    msg = {
                        'status': 500,
                        'error': 'erreur interne',
                        'code': return_code,
                        'message': message
                        }
                    LOGS.logger.error(msg)
                else:
                    LOGS.logger.info(message)
                ch.basic_ack(delivery_tag=method.delivery_tag)

        try:
            document = json.loads(body.decode('utf-8'))
        except Exception as exc:
            LOGS.logger.error(exc)
            ch.basic_ack(delivery_tag=method.delivery_tag)
        else:
            LOGS.logger.info('queue : {}'.format(queue))
            if queue == 'PUT.hlr':
                # activate 3g or lte
                service_type = document['service_type']
                if service_type == 'activate_3g':
                    imsi = document['json']['imsi']
                    tplid = document['json']['tplid']
                    return activate_3g(imsi, tplid)
                elif service_type == 'activate_lte':
                    imsi = document['json']['imsi']
                    tplid = document['json']['tplid']
                    apntplid = document['json']['apntplid']
                    return activate_lte(apntplid, imsi, tplid)
                elif service_type == 'desactivate_lte':
                    imsi = document['json']['imsi']
                    return desactivate_lte(imsi)
                ch.basic_ack(delivery_tag=method.delivery_tag)
            else:
                # create subscriber
                LOGS.logger.info('not service_type')
                condition = (
                    'isdn' not in document['json'] or
                    'imsi' not in document['json']
                    )
                if condition:
                    ch.basic_ack(delivery_tag=method.delivery_tag)
                else:
                    imsi = document['json']['imsi']
                    isdn = document['json']['isdn']
                    try:
                        telnet_client.add_subscriber(imsi, isdn)
                    except Exception as exc:
                        LOGS.logger.error(exc)
                        ch.basic_publish(
                            exchange='sendcmd',
                            routing_key=queue,
                            body=json.dumps(document),
                            properties=pika.BasicProperties(delivery_mode=2)
                            )
                    else:
                        code = telnet_client.response['code']
                        message = telnet_client.response['message']
                        return_code = '{service_code}-{code}'.format(
                            service_code=SERVICE_CODE,
                            code=code
                            )
                        if code:
                            if code == 3002:
                                # envoyer un SMS pour dire qu'en fait c'est ok
                                LOGS.logger.info(message)
                            else:
                                msg = {
                                    'status': 500,
                                    'error': 'erreur interne',
                                    'code': return_code,
                                    'message': message
                                    }
                                LOGS.logger.error(msg)
                        else:
                            telnet_client.update_gprs_profile(imsi, True)
                            code = telnet_client.response['code']
                            message = telnet_client.response['message']
                            return_code = '{service_code}-{code}'.format(
                                service_code=SERVICE_CODE,
                                code=code
                                )
                            if code:
                                msg = {
                                    'status': 500,
                                    'error': 'erreur interne',
                                    'code': return_code,
                                    'message': message
                                    }
                                LOGS.logger.error(msg)
                            else:
                                LOGS.logger.info(message)
                                # envoyer un SMS pour dire c'est OK
                    ch.basic_ack(delivery_tag=method.delivery_tag)

    connection = pika.BlockingConnection(
        pika.ConnectionParameters(
            host='localhost',
            virtual_host='/hlr'
            )
        )
    channel = connection.channel()
    channel.basic_qos(prefetch_count=1)
    channel.basic_consume(callback, queue=queue)
    channel.start_consuming()


class Worker(threading.Thread):

    def __init__(self, name, queue):
        threading.Thread.__init__(self)
        self.name = name
        self.queue = queue
        self.telnet_client = Client()
        self.url_smsc = CONFIG['SERVICES']['smsc']

    def run(self):
        process(self.telnet_client, self.url_smsc, self.queue)


# EOF
