#!/usr/bin/env python
# encoding: utf-8


from flask import jsonify

from blueflask.lib.decorators import auth as ldap
from blueflask.lib.errors import not_found
from blueflask.lib.infos import no_content

from ...consts import REDIS_SERVER, SERVICE_CODE
from . import api


@api.route('/requests', methods=['GET'])
@ldap.login_required
def get_all_existing_requests():
    keys = REDIS_SERVER.keys('ldap:*')
    if not keys:
        return no_content(service_code=SERVICE_CODE)
    else:
        result = {
            'requests': [
                {
                    'request_id': key.decode('utf-8').split(':')[1],
                    'status': float(REDIS_SERVER.hget(key, 'status'))
                    }
                for key in keys
                ],
            'length': len(keys)
            }
        return jsonify(result)


@api.route('/requests/<string:request_id>', methods=['GET'])
@ldap.login_required
def get_request_response(request_id):
    response = REDIS_SERVER.hgetall('ldap:'+request_id)
    if not response:
        return not_found(service_code=SERVICE_CODE)
    else:
        status = float(response[b'status'])
        content = eval(response[b'content'])
        result = jsonify(content)
        result.status_code = status
        REDIS_SERVER.delete('ldap:'+request_id)
        return result

# EOF
