#!/usr/bin/env python
# encoding: utf-8

"""
Constantes de l'application
"""

from to_log import Logger

import configparser
import socket

import ldap
import redis


__all__ = [
    'CONFIG',
    'LDAP_SERVER',
    'LDAP_ADMIN_DN',
    'LDAP_CONN',
    'LOGS',
    'REDIS_SERVER',
    'SERVICE_CODE',
    'HOSTNAME',
    'API_REGISTRY'
    ]


CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/ldap-services/ldap-services.conf')

SERVICE_CODE = CONFIG['APP']['service_code']
HOSTNAME = socket.gethostname().split('.')[0]
API_REGISTRY = redis.Redis(db=15)
if HOSTNAME.startswith('blpr'):
    API_REGISTRY = redis.Redis(host='api.blueline.mg', db=15)

LDAP_SERVER = CONFIG['LDAP']['LDAP_SERVER']
LDAP_ADMIN_DN = CONFIG['LDAP']['LDAP_ADMIN_DN']
LDAP_CONN = ldap.initialize(LDAP_SERVER)
LDAP_CONN.bind(LDAP_ADMIN_DN, CONFIG['LDAP']['LDAP_ADMIN_PASSWORD'])

LOG_LEVEL = CONFIG['LOGS']['level']
LOG_FILE = CONFIG['LOGS']['filename']

LOGS = Logger('ldap-services')
LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

API_LOGS = Logger('ldap-services-api')
LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

BLUEFLASK_LOGS = Logger('blueflask')
BLUEFLASK_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

REDIS_SERVER = redis.Redis()

# EOF
