#!/usr/bin/env python
# encoding: utf-8

"""
Constantes de l'application
"""

from to_log import Logger

import configparser
import socket

import ldap


__all__ = [
    "ADDRESS",
    "APIGW",
    "CONFIG",
    "HOSTNAME",
    "LDAP_ADMIN_DN",
    "LDAP_CONN",
    "LDAP_SERVER",
    "LOGS",
    "SERVICE_CODE",
]


CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read("/etc/ldap-services/ldap-services.conf")

SERVICE_CODE = CONFIG["APP"]["service_code"]
GUNICORN_PORT = int(SERVICE_CODE[1:].replace("-", ""))
HOSTNAME = socket.gethostname().split(".")[0]
_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
_socket.connect(("41.204.103.205", 80))
ADDRESS = _socket.getsockname()[0]

if HOSTNAME.startswith("bldv"):
    APIGW = "bldv040v.blueline.mg"
elif HOSTNAME.startswith("blst"):
    APIGW = "blst040v.blueline.mg"
else:
    APIGW = "api.blueline.mg"

LDAP_SERVER = CONFIG["LDAP"]["LDAP_SERVER"]
LDAP_ADMIN_DN = CONFIG["LDAP"]["LDAP_ADMIN_DN"]
LDAP_CONN = ldap.initialize(LDAP_SERVER)
LOG_LEVEL = CONFIG["LOGS"]["level"]
LOG_FILE = CONFIG["LOGS"]["filename"]

LOGS = Logger("ldap-services")
LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

API_LOGS = Logger("ldap-services-api")
LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

BLUEFLASK_LOGS = Logger("blueflask")
BLUEFLASK_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

# EOF
