# -*- coding: utf-8 -*-

# from rest_client import RestClient
from to_log import Logger
import configparser
import socket
import requests
import datetime
import hashlib


__all__ = [
    'ADDRESS',
    'APIGW',
    'API_LOGS',
    'BLUEFLASK_LOGS',
    'CONFIG',
    'HOSTNAME',
    'LOGS',
    'REST_CLIENT_LOGS'
    ]

CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/motv-services/motv-services.conf')

SERVICE_CODE = CONFIG['APP']['service_code']
HOSTNAME = socket.gethostname().split('.')[0]
_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
_socket.connect(("41.204.103.205", 80))
ADDRESS = _socket.getsockname()[0]
if HOSTNAME.startswith('bldv'):
    APIGW = 'bldv040v.blueline.mg'
elif HOSTNAME.startswith('blst'):
    APIGW = 'blst040v.blueline.mg'
else:
    APIGW = 'api.blueline.mg'

LOG_LEVEL = CONFIG['LOGS']['level']
LOG_FILE = CONFIG['LOGS']['filename']

LOGS = Logger('motv-services', level=LOG_LEVEL)
LOGS.set_file_handler(LOG_FILE)

API_LOGS = Logger('motv-services-api', level=LOG_LEVEL)
API_LOGS.set_file_handler(LOG_FILE)

REST_CLIENT_LOGS = Logger(
    'rest_client',
    level=LOG_LEVEL
    )
REST_CLIENT_LOGS.set_file_handler(LOG_FILE)

BLUEFLASK_LOGS = Logger(
    'blueflask',
    level=LOG_LEVEL
    )
BLUEFLASK_LOGS.set_file_handler(LOG_FILE)
SESSION = requests.Session()
MOTV_URI = CONFIG['MOTV']['url_mw']
MOTV_LOGIN = CONFIG['MOTV']['username']
MOTV_PSW = CONFIG['MOTV']['password']


def hashing(timestamp, mail, password):
    token = '{timestamp}{mail}{password}'.format(
            timestamp=timestamp,
            mail=mail,
            password=password
            )
    hash_object = hashlib.sha1(bytes(token, encoding='utf-8'))
    return hash_object.hexdigest()


TIMESTAMP, x = (str((datetime.datetime.now()).timestamp())).split('.')
TOKEN = hashing(TIMESTAMP, MOTV_LOGIN, MOTV_PSW)

HEADERS = {
        'Authorization-user': (
            '{login}:{timestamp}:{token}'.format(
                login=MOTV_LOGIN,
                timestamp=TIMESTAMP,
                token=TOKEN
                )
            ),
    }

TOKEN_SMS = {"token": "SXg3v#v3-d"}
SMS_URI = CONFIG['MOTV']['url_sms']

LDAP_LOGIN = CONFIG['LDAP']['login']
LDAP_PSW = CONFIG['LDAP']['password']
TOKEN_URL = CONFIG['LDAP']['url_token']
SMSC_URI = CONFIG['SMSC']['url_smsc']
OCS_URI = CONFIG['OCS']['url_ocs']
WSDL = CONFIG['4D']['4dwsdl']
PAYLOAD = {
    'root': {
        'header': {
            'version': '1',
            'param1': None,
            'ident': CONFIG['4D']['ident'],
            'psw': CONFIG['4D']['psw'],
            },
        'data': None
        }
    }
NOTIFICATION_URL = CONFIG['NOTIFICATION']['url']
DB_CREDENTIALS = CONFIG["DB"]
