# -*- conding: utf-8 -*-

from .consts import SMS_URI, TOKEN_SMS, LOGS
from .code_error import CODE_ERROR
import requests
import json


class Customer(object):

    def __init__(self, login=None):
        self.login = login

    def getDataByLogin(self):
        data = {
            "data": {
                "login": self.login,
                },
            "auth": TOKEN_SMS
            }
        data = json.dumps(data)
        # LOGS.logger.info("IzyTv get data by login:\n"+data)
        response = requests.post(
            '{uri}/devices/motv/apiGetDataByLogin'.format(uri=SMS_URI),
            data=data
            )
        if response.status_code == 200:
            status_code = 200
            response = response.json()
            if response["status"] == 1:
                status_code = 1
                info = "IzyTv getData by login successfully ;)"
                data = response["response"]
            else:
                status_code = response["status"]
                info = "IzyTv getData by login {error}!!!".format(
                        error=(CODE_ERROR.get(str(response["status"]))).lower()
                        )
                data = {}
        else:
            status_code = response.status_code
            info = "IzyTv getData by login failed!!!"
            data = {}

        response = {
            "code": "044-05-{}".format(status_code),
            "info": info,
            "response": data,
            "status": status_code,
            }
        # LOGS.logger.info(response)
        return response

    def getData(self, viewers_id):
        data = {
            "data": {
                "viewers_id": viewers_id
                },
            "auth": TOKEN_SMS
            }
        data = json.dumps(data)
        LOGS.logger.info("IzyTv get data by viewers_id:\n"+data)
        response = requests.post(
            '{uri}/customer/getData'.format(uri=SMS_URI),
            data=data
            )
        if response.status_code == 200:
            status_code = 200
            response = response.json()
            if response["status"] == 1:
                status_code = 1
                info = "IzyTv getData by viewers_id successfully ;)"
                data = response["response"]
            else:
                status_code = response["status"]
                info = "IzyTv getData by viewers_id {error}!!!".format(
                        error=(CODE_ERROR.get(str(response["status"]))).lower()
                        )
                data = {}
        else:
            status_code = response.status_code
            info = "IzyTv getData by viewers_id failed!!!"
            data = {}

        response = {
            "code": "044-05-{}".format(status_code),
            "info": info,
            "response": data,
            "status": status_code,
            }
        LOGS.logger.info(response)
        return response

    def getAllowedProduct(self, viewers_id):
        data = {
            "data": {
                "viewers_id": viewers_id,
                },
            "auth": TOKEN_SMS
            }
        data = json.dumps(data)
        LOGS.logger.info("IzyTv get allowed product by viewers_id:\n"+data)
        response = requests.post(
            '{uri}/sales/getAllowedProductsForCustomer'.format(uri=SMS_URI),
            data=data
            )
        if response.status_code == 200:
            status_code = 200
            response = response.json()
            if response["status"] == 1:
                status_code = 1
                info = "IzyTv getAllowedProduct by viewers_id successfully ;)"
                data = response["response"]
            else:
                status_code = response["status"]
                info = "IzyTv getAllowedProduct by viewers_id {error}".format(
                        error=(CODE_ERROR.get(str(response["status"]))).lower()
                        )
                data = {}
        else:
            status_code = response.status_code
            info = "IzyTv getAllowedProduct by viewers_id failed!!!"
            data = {}

        response = {
            "code": "044-05-{}".format(status_code),
            "info": info,
            "response": data,
            "status": status_code,
            }
        LOGS.logger.info(response)
        return response

    def all(self):
        data = {
            "data": {
                "reports_id": 2,
                "page": 1,
                "page_limit": 50
                },
            "auth": TOKEN_SMS
            }
        data = json.dumps(data)
        LOGS.logger.info("IzyTv get all customer:\n"+data)
        response = requests.post(
            '{uri}/report/reportSelection'.format(uri=SMS_URI),
            data=data
            )
        if response.status_code == 200:
            status_code = 200
            response = response.json()
            if response["status"] == 1:
                status_code = 1
                info = "IzyTv get all customer successfully ;)"
                data = response["response"]["rows"]
            else:
                status_code = response["status"]
                info = "IzyTv get all customer {error}".format(
                        error=(CODE_ERROR.get(str(response["status"]))).lower()
                        )
                data = {}
        else:
            status_code = response.status_code
            info = "IzyTv get all customer failed!!!"
            data = {}

        response = {
            "code": "044-05-{}".format(status_code),
            "info": info,
            "response": data,
            "status": status_code,
            }
        LOGS.logger.info(response)
        return response

    def all_customer(self):
        data = {
            "data": {
                "reports_id": 2,
                "page": None,
                "page_limit": None
                },
            "auth": TOKEN_SMS
            }
        data = json.dumps(data)
        LOGS.logger.info("IzyTv get all customer:\n"+data)
        response = requests.post(
            '{uri}/report/reportSelection'.format(uri=SMS_URI),
            data=data
            )
        if response.status_code == 200:
            status_code = 200
            response = response.json()
            if response["status"] == 1:
                status_code = 1
                info = "IzyTv get all customer successfully ;)"
                data = response["response"]["rows"]
            else:
                status_code = response["status"]
                info = "IzyTv get all customer {error}".format(
                        error=(CODE_ERROR.get(str(response["status"]))).lower()
                        )
                data = {}
        else:
            status_code = response.status_code
            info = "IzyTv get all customer failed!!!"
            data = {}

        response = {
            "code": "044-05-{}".format(status_code),
            "info": info,
            "response": data,
            "status": status_code,
            }
        LOGS.logger.info(response)
        # return response
        return data

    def register(self, data):
        LOGS.logger.info("IzyTv customer register:\n"+data)
        response = requests.post(
            '{uri}/customer/update'.format(uri=SMS_URI),
            data=data
            )
        if response.status_code == 200:
            status_code = 200
            response = response.json()
            if response["status"] == 1:
                status_code = 1
                info = "IzyTv customer register successfully ;)"
                data = response["response"]
            else:
                status_code = response["status"]
                info = "IzyTv customer register {error}".format(
                        error=(CODE_ERROR.get(str(response["status"]))).lower()
                        )
                data = {}
        else:
            status_code = response.status_code
            info = "IzyTv customer register failed!!!"
            data = {}

        response = {
            "code": "044-05-{}".format(status_code),
            "info": info,
            "response": data,
            "status": status_code,
            }
        LOGS.logger.info(response)
        return response

    def changePassword(self, new_password):
        info_bylogin = {
            "data": {
                "login": self.login,
                },
            "auth": TOKEN_SMS
            }
        info_bylogin = json.dumps(info_bylogin)
        LOGS.logger.info("IzyTv get info bylogin to change password{}".format(
            info_bylogin
            )
        )
        infos = requests.post(
            '{uri}/devices/motv/apiGetDataByLogin'.format(uri=SMS_URI),
            data=info_bylogin
            )
        if infos.status_code == 200:
            infos = infos.json()
            if infos["status"] == 1:
                data = {
                    "data": {
                        "viewers_id": (
                            infos["response"]["device_motv_viewers_id"]
                            ),
                        "device_id": infos["response"]["device_motv_id"],
                        "data": {"device_motv_password": new_password}
                    },
                    "auth": TOKEN_SMS
                }
                data = json.dumps(data)
                LOGS.logger.info("IzyTv customer change password:\n"+data)
                response = requests.post(
                    '{uri}/devices/motv/update'.format(uri=SMS_URI),
                    data=data
                    )
                if response.status_code == 200:
                    status_code = 200
                    response = response.json()
                    if response["status"] == 1:
                        status_code = 1
                        info = "IzyTv customer change password successfully ;)"
                        data = response["response"]
                    else:
                        status_code = response["status"]
                        info = (
                            "IzyTv customer change password {}".format(
                                (
                                    CODE_ERROR.get(str(response["status"]))
                                    ).lower()
                                )
                            )
                        data = {}
                else:
                    status_code = response.status_code
                    info = "IzyTv customer change password failed!!!"
                    data = {}
            else:
                status_code = infos["status"]
                info = (
                    "IzyTv get info bylogin to change password {}".format(
                     (CODE_ERROR.get(str(infos["status"]))).lower()
                     ))
                data = {}
        else:
            status_code = infos.status
            info = "IzyTv get info bylogin to change password failed!!!"
            data = {}
        response = {
            "code": "044-05-{}".format(status_code),
            "info": info,
            "response": data,
            "status": status_code,
            }
        LOGS.logger.info(response)
        return response

    def delete(self, viewers_id):
        viewers_id = int(viewers_id)
        data = {
            "data": {
                "viewers_id": viewers_id,
                },
            "auth": TOKEN_SMS
            }
        data = json.dumps(data)
        LOGS.logger.info("IzyTv delete customer {}".format(viewers_id))
        response = requests.post(
            '{uri}/customer/deleteCustomer'.format(uri=SMS_URI),
            data=data
        )
        if response.status_code == 200:
            response = response.json()
            if response["status"] == 1:
                status_code = 1
                info = (
                    "IzyTv, the customer {} has been deleted successfully!"
                    ).format(viewers_id)
            else:
                status_code = response["status"]
                info = "IzyTv delete customer by viewers_id {error}!".format(
                        error=(
                            CODE_ERROR.get(str(response["status"]))
                            ).lower()
                        )
        else:
            status_code = response.status_code
            info = "Erreur pour atteindre le serveur izytv"

        response = {
            "status": status_code,
            "info": info
            }
        LOGS.logger.info(response)
        return response


class Subscription(object):

    def __init__(self, viewers_bouquets_id):
        self.viewers_bouquets_id = viewers_bouquets_id

    def suspendSubscription(self):
        data = {
            "data": {
                "viewers_bouquets_id": self.viewers_bouquets_id,
                },
            "auth": TOKEN_SMS
            }
        data = json.dumps(data)
        LOGS.logger.info("IzyTv suspend subscription:\n"+data)
        response = requests.post(
            '{uri}/subscription/suspendSubscription'.format(uri=SMS_URI),
            data=data
            )
        if response.status_code == 200:
            status_code = 200
            response = response.json()
            if response["status"] == 1:
                status_code = 1
                info = "IzyTv suspend subscription successfully ;)"
                data = response["response"]
            else:
                status_code = response["status"]
                info = "IzyTv suspend subscription {error}".format(
                        error=(CODE_ERROR.get(str(response["status"]))).lower()
                        )
                data = {}
        else:
            status_code = response.status_code
            info = "IzyTv get all customer failed!!!"
            data = {}

        response = {
            "code": "044-05-{}".format(status_code),
            "info": info,
            "response": data,
            "status": status_code,
            }
        LOGS.logger.info(response)
        return response

    def resumeSubscription(self):
        data = {
            "data": {
                "viewers_bouquets_id": self.viewers_bouquets_id,
                },
            "auth": TOKEN_SMS
            }
        data = json.dumps(data)
        LOGS.logger.info("IzyTv resume subscription:\n"+data)
        response = requests.post(
            '{uri}/subscription/resumeSubscription'.format(uri=SMS_URI),
            data=data
            )
        if response.status_code == 200:
            status_code = 200
            response = response.json()
            if response["status"] == 1:
                status_code = 1
                info = "IzyTv resume subscription successfully ;)"
                data = response["response"]
            else:
                status_code = response["status"]
                info = "IzyTv resume subscription {error}".format(
                        error=(CODE_ERROR.get(str(response["status"]))).lower()
                        )
                data = {}
        else:
            status_code = response.status_code
            info = "IzyTv get all customer failed!!!"
            data = {}

        response = {
            "code": "044-05-{}".format(status_code),
            "info": info,
            "response": data,
            "status": status_code,
            }
        LOGS.logger.info(response)
        return response

    def cancelSubscription(self):
        data = {
            "data": {
                "viewers_bouquets_id": self.viewers_bouquets_id,
                },
            "auth": TOKEN_SMS
            }
        data = json.dumps(data)
        LOGS.logger.info("IzyTv resume subscription:\n"+data)
        response = requests.post(
            '{uri}/subscription/cancelSubscription'.format(uri=SMS_URI),
            data=data
            )
        if response.status_code == 200:
            status_code = 200
            response = response.json()
            if response["status"] == 1:
                status_code = 1
                info = "IzyTv resume subscription successfully ;)"
                data = response["response"]
            else:
                status_code = response["status"]
                info = "IzyTv resume subscription {error}".format(
                        error=(CODE_ERROR.get(str(response["status"]))).lower()
                        )
                data = {}
        else:
            status_code = response.status_code
            info = "IzyTv get all customer failed!!!"
            data = {}

        response = {
            "code": "044-05-{}".format(status_code),
            "info": info,
            "response": data,
            "status": status_code,
            }
        LOGS.logger.info(response)
        return response


# EOF
