# -*- coding: utf-8 -*-

from blueflask.lib.errors import bad_request
from blueflask.lib.infos import success
from flask import jsonify, request
from ...consts import (
    # MOTV_URI,
    # hashing,
    # MOTV_LOGIN,
    # MOTV_PSW,
    TOKEN_SMS,
    SMS_URI,
    LOGS,
    SERVICE_CODE
    )
# from ...code_error import CODE_ERROR
from . import api
from ...ocs import get_language, send_sms, get_balance, update_balance
from ...sms import MESSAGE
from ...bluebase import (
    customer_register,
    customer_update,
    customer_notif,
    izytv_auth_ussd,
    izytv_get_subscription_infos,
    izytv_get_offer,
    izytv_buy_recharge,
    auth_ussd
    )
from ...motv import Customer
import requests
import json


@api.route('/sms/customer/all', methods=['GET'])
def smsCustomerReportSelection():
    """
    Tout les clients
    """
    customer = Customer()
    response = customer.all()
    return jsonify(response)


@api.route('/sms/customer/getdata/<string:viewers_id>', methods=['GET'])
def smsCustomerGetData(viewers_id):
    """
    Get data by viewers_id
    """
    customer = Customer()
    response = customer.getData(int(viewers_id))
    return jsonify(response)


@api.route(
    '/customer/getDataByLogin/<string:login>', methods=['GET']
    )
def customerGetDataByLogin(login):
    """
    Get data by login
    """
    customer = Customer(login)
    response = customer.getDataByLogin()
    return jsonify(response)


@api.route(
    '/sms/customer/changePassword',
    methods=['POST']
    )
def smsCustomerChangepassword():
    """
    Change password
    """
    data = request.get_json()
    customer = Customer(data["login"])
    response = customer.changePassword(data["new_password"])
    return jsonify(response)


@api.route(
    '/sms/customer/getAllowedProducts/<string:viewers_id>', methods=['GET']
    )
def smsCustomerGetAllowedProducts(viewers_id):
    """
    Get allowed products
    """
    customer = Customer()
    response = customer.getAllowedProduct(int(viewers_id))
    return jsonify(response)


@api.route('/sms/customer/getSubscriptionInfo', methods=['GET'])
def smsCustomerGetSubscriptionInfo():
    data = request.get_json()
    data["auth"] = TOKEN_SMS
    data["data"] = data.pop("data1")
    data.get('data')['viewers_id'] = int(data.get('data')['viewers_id'])
    data = json.dumps(data)
    response = requests.post(
        '{uri}/subscription/getCustomerSubscriptionInfo'.format(uri=SMS_URI),
        data=data
        )
    response = response.json()
    return jsonify(response)


@api.route('/sms/customer/cancelSubscription', methods=['POST'])
def smsCustomerCancelSubscription():
    data = request.get_json()
    data["auth"] = TOKEN_SMS
    data["data"] = data.pop("data1")
    data.get('data')['viewers_bouquets_id'] = (
        int(data.get('data')['viewers_bouquets_id'])
        )
    data = json.dumps(data)
    response = requests.post(
        '{uri}/subscription/cancelSubscription'.format(uri=SMS_URI),
        data=data
        )
    response = response.json()
    return jsonify(response)


@api.route('/sms/customer/suspendSubscription', methods=['POST'])
def smsCustomerSuspendSubscription():
    data = request.get_json()
    data["auth"] = TOKEN_SMS
    data["data"] = data.pop("data1")
    data.get('data')['viewers_bouquets_id'] = (
        int(data.get('data')['viewers_bouquets_id'])
        )
    data = json.dumps(data)
    response = requests.post(
        '{uri}/subscription/suspendSubscription'.format(uri=SMS_URI),
        data=data
        )
    response = response.json()
    return jsonify(response)


@api.route('/sms/customer/resumeSubscription', methods=['POST'])
def smsCustomerResumeSubscription():
    data = request.get_json()
    data["auth"] = TOKEN_SMS
    data["data"] = data.pop("data1")
    data.get('data')['viewers_bouquets_id'] = (
        int(data.get('data')['viewers_bouquets_id'])
        )
    data = json.dumps(data)
    response = requests.post(
        '{uri}/subscription/resumeSubscription'.format(uri=SMS_URI),
        data=data
        )
    response = response.json()
    return jsonify(response)


@api.route('/sms/customer/register', methods=['POST'])
def smsCustomerRegister():

    data = request.get_json()
    data["auth"] = TOKEN_SMS
    data["data"] = data.pop("data1")
    if "viewers_id" not in data["data"]:
        data["data"]["viewers_id"] = None
    data["data"]["data"] = data["data"].pop("data2")
    if type(data["data"]["data"]["devices"]) != list:
        data["data"]["data"]["devices"] = [data["data"]["data"]["devices"]]
        data["data"]["data"]["devices"][0]["device_motv_id"] = ""
        data["data"]["data"]["devices"][0]["device_motv_motv_portals_id"] = (
            int(
                data["data"]["data"]["devices"][0][
                    "device_motv_motv_portals_id"
                ]
                )
            )
    data["data"]["data"]["contacts"] = [
        {
            "viewers_contact_type": "Mobile",
            "viewers_contact_content": data["data"]["data"].get(["phone"])
            },
        {
            "viewers_contact_type": "Email",
            "viewers_contact_content": data["data"]["data"].get(["mail"])
            }
        ]
    del(data["data"]["data"]["phone"])
    del(data["data"]["data"]["mail"])

    data["data"]["data"]["addresses"] = [
        {
            "viewers_address_type": "Customer address",
            "viewers_address_address": data["data"]["data"].get(["rue"]),
            "viewers_address_streetname": data["data"]["data"].get(["rue"]),
            "viewers_address_city": data["data"]["data"].get(["ville"]),
        },
        ]
    del(data["data"]["data"]["rue"])
    del(data["data"]["data"]["ville"])
    data = json.dumps(data)
    response = requests.post(
        '{uri}/customer/update'.format(uri=SMS_URI),
        data=data
        )
    response = response.json()
    return jsonify(response)


@api.route('/sms/customer/delete', methods=['POST'])
def smsDeleteCustomer():
    """
    Delete customer
    """
    data = request.get_json()
    data["data"] = data.pop("data1")
    customer = Customer()
    response = customer.delete(int(data["data"]["viewers_id"]))
    return jsonify(response)


@api.route('/sms/customer/saveInvoice', methods=['POST'])
def smsCustomerSaveInvoice():

    data = request.get_json()
    data["auth"] = TOKEN_SMS
    data["data"] = data.pop("data1")
    LOGS.logger.info(data)
    if type(data["data"]["viewers_id"]) != int:
        data["data"]["viewers_id"] = int(data["data"]["viewers_id"])

    if type(data["data"]["devices"]) != list:
        data["data"]["devices"] = (
            [[
                data["data"]["devices"]["type"],
                data["data"]["devices"]["devices_id"]
            ]]
        )
    if type(data["data"]["devices"][0][1]) != int:
        data["data"]["devices"][0][1] = int(data["data"]["devices"][0][1])

    if type(data["data"]["invoice_data"]["products"]) != list:
        data["data"]["invoice_data"]["products"] = [
            data["data"]["invoice_data"]["products"]
        ]
    if type(
        data["data"]["invoice_data"]["products"][0]["products_id"]
            ) != int:
        data["data"]["invoice_data"]["products"][0]["products_id"] = (
            int(data["data"]["invoice_data"]["products"][0]["products_id"])
            )
    devices_id = data["data"]["devices"][0][1]
    data = json.dumps(data)
    response = requests.post(
        '{uri}/sales/saveInvoice'.format(uri=SMS_URI),
        data=data
        )
    if response.status_code == 200:
        response = response.json()
        if response["status"] == 480:
            response = {
                "response": (
                    """The device ID ({devices_id}) """
                    """that you're passing does not exist""".format(
                        devices_id=devices_id
                        )
                    ),
                "status": response["status"]
            }
            LOGS.logger.info(response)
        elif response["status"] == 1:
            LOGS.logger.info(response)
            response = {
                "invoices": response["response"]["invoices"],
                "status": response["status"]
                }
            LOGS.logger.info("Activation successful")
            LOGS.logger.info(response)
        else:
            response = {
                "invoices": response["response"],
                "status": response["status"]
                }
            LOGS.logger.info("Activation failed")
            LOGS.logger.info(response)
    else:
        response = {
                "Erreur": "Activation failed",
                "status": response.status_code
            }
        LOGS.logger.info("Activation failed")
        LOGS.logger.info(response)

    return jsonify(response)


# ussd

@api.route(
    '/motv/authenticate/izytv', methods=['POST']
    )
def authenticate_ussd():
    data = request.get_json()
    response = auth_ussd(data)
    return jsonify(response)


@api.route(
    '/clients/authenticate/izytv', methods=['POST']
    )
def ussdCustomerGetDataByLogin():
    params = request.get_json()
    data = {
        "data": {
            "login": params["login"],
            },
        "auth": TOKEN_SMS
    }

    data = json.dumps(data)
    LOGS.logger.info(data)
    response = requests.post(
        '{uri}/devices/motv/apiGetDataByLogin'.format(uri=SMS_URI),
        data=data
        )
    if response.status_code == 200:
        response = response.json()
        if response["status"] == 1:
            response = {
                "code": "044-05-200",
                "message": {
                    "customer_name": (
                        response["response"]["device_motv_login"]
                        ),
                    "customer_id": (
                        response["response"]["device_motv_viewers_id"]
                        ),
                    },
                "status": 200,
                }
            LOGS.logger.info(response)
        elif response["status"] == 14001:
            response = {
                "code": "044-05-4011",
                "message": "Izytv incorrect login",
                "status": 4011,
                }
            LOGS.logger.info(response)
            return bad_request(
                service_code=SERVICE_CODE,
                code="{service_code}-{code}".format(
                    service_code=SERVICE_CODE, code=4011)
                )
        else:
            response = {
                "code": "044-05-{}".format(response["status"]),
                "message": "Izytv errors",
                "status": response["status"],
                }
            LOGS.logger.info(response)
            return bad_request(
                service_code=SERVICE_CODE,
                code="{service_code}-{code}".format(
                    service_code=SERVICE_CODE, code=response["status"])
                )
    else:
        response = {
            "code": "044-05-{}".format(response.status_code),
            "message": "Izytv errors",
            "status": response.status_code,
            }
        LOGS.logger.info(response)
        return bad_request(
            service_code=SERVICE_CODE,
            code="{service_code}-{code}".format(
                service_code=SERVICE_CODE, code=response.status_code)
            )
    return jsonify(response)


@api.route(
    'clients/authenticate/verify-code-izytv', methods=['POST']
    )
def ussdCustomerLogin():
    params = request.get_json()
    data = {
        "data": {
            "login": params["login"],
            "password": params["secret_code"],
            },
        "auth": TOKEN_SMS
    }

    data = json.dumps(data)
    LOGS.logger.info(data)
    response = requests.post(
        '{uri}/devices/motv/apiLogin'.format(uri=SMS_URI),
        data=data
        )
    if response.status_code == 200:
        LOGS.logger.info(response.json())
        code = response.json()["status"]
        if code == 1:
            response = {
                "code": "044-05-{}".format(response.status_code),
                "info": "Activation du produit",
                "message": "Authentification OK :)",
                "status": response.status_code,
            }
            LOGS.logger.info(response)
            return success(service_code=SERVICE_CODE)
        else:
            response = {
                    "code": "044-05-{}".format("4013"),
                    "info": "Activation du produit",
                    "message": "Erreur d'authentification",
                    "status": "4013",
                }
            LOGS.logger.info(response)
            return bad_request(
                service_code=SERVICE_CODE,
                code='{service_code}-{code}'.format(
                    service_code=SERVICE_CODE,
                    code=4013
                    )
                )
    else:
        response = {
                "code": "044-05-{}".format(response.status_code),
                "info": "Activation du produit",
                "message": "Erreur d'authentification",
                "status": response.status_code,
            }
        LOGS.logger.info(response)
        return bad_request(
            service_code=SERVICE_CODE,
            code='{service_code}-{code}'.format(
                service_code=SERVICE_CODE,
                code=response.status_code
                )
            )

    return jsonify(response)


@api.route(
    '/clients/<string:login>/infos/izytv',
    methods=['GET']
    )
def ussdGetcustomerInfo(login):
    params = request.get_json()
    customer = izytv_auth_ussd(login, params['caller_num'])
    return jsonify(customer)


@api.route(
    '/clients/<string:login>/offers/izytv',
    methods=['GET']
    )
def ussdCustomerGetAllowedProducts(login):
    params = request.get_json()
    customer = izytv_auth_ussd(login, params['caller_num'])
    if customer["status"] == 200:
        data = {
            'session': '',
            "operator": "bip",
            "caller_num": params['caller_num'],
            "service_type": "izytv",
            "client_refnum": customer['message']['client_refnum'],
            "device_id": login,
            "solde": "200000",
            "jour": "0"
            }
        response = izytv_get_offer(data)
        if response["status"] == 200:
            products = []
            for i in response["message"]:
                product = {
                    "name": i['intitule'],
                    "offer_id": i["refnum"],
                    "price": i["price"]
                    }
                products.append(product)
            response = {
                "code": "044-05-200",
                "message": {"offers": products},
                "status": 200,
                }
            LOGS.logger.info("Get offers successful")
            LOGS.logger.info(response)
        else:
            LOGS.logger.info("Get offers failed")
            LOGS.logger.info(response)
            return bad_request(
                service_code=SERVICE_CODE,
                code='{service_code}-{code}'.format(
                    service_code=SERVICE_CODE,
                    code=response["status"]
                    )
                )
    else:
        response = customer
        return bad_request(
            service_code=SERVICE_CODE,
            code='{service_code}-{code}'.format(
                service_code=SERVICE_CODE,
                code=response["status"]
                )
            )
    return jsonify(response)


@api.route(
    '/clients/<string:login>/subscriptions/izytv',
    methods=['GET']
    )
def subscriptionInfo(login):
    """
    Pour avoir les offers sur lesquelles le client est inscrit
    """
    params = request.get_json()
    customer = izytv_auth_ussd(login, params['caller_num'])
    if customer["status"] == 200:
        data = {
            'session': '',
            "operator": "bip",
            "caller_num": params['caller_num'],
            "service_type": "izytv",
            "client_refnum": customer['message']['client_refnum'],
            "device_id": login
        }
        response = izytv_get_subscription_infos(data)
        if response["status"] == 200:
            response = {
                "code": "044-05-200",
                "message": {"subscriptions": response["message"]},
                "status": 200,
                }
            LOGS.logger.info("Get subscriptions successful")
            LOGS.logger.info(response)
        elif response["status"] == 4016:
            LOGS.logger.info("Get subscriptions failed")
            LOGS.logger.info(response)
            return bad_request(
                service_code=SERVICE_CODE,
                code='{service_code}-{code}'.format(
                    service_code=SERVICE_CODE,
                    code=4016
                    )
                )
    else:
        response = customer
        return bad_request(
            service_code=SERVICE_CODE,
            code='{service_code}-{code}'.format(
                service_code=SERVICE_CODE,
                code=response["status"]
                )
            )
    return jsonify(response)


@api.route(
    '/clients/<string:login>/offers/izytv',
    methods=['POST']
    )
def ussdCustomerSaveInvoice(login):
    """
    Activation offre par ussd
    """
    params = request.get_json()
    auth = request.authorization

    # get language
    language = get_language(
        params["caller_num"],
        auth.username
        )
    if language == 1:  # EN
        lg = "en"
    elif language == 2:  # FR
        lg = "fr"
    elif language == 3:
        lg = "mg"

    # get_balance on ocs
    balance = get_balance(params["caller_num"], auth.username)
    if balance['info'] != "Erreur":
        if int(balance["message"]["balance"]) >= int(float(params["amount"])):
            # get refnum
            customer = izytv_auth_ussd(login, params["caller_num"])
            # Verifier si la requête est passée
            if customer["status"] == 200:
                # update de la balance du client
                account_new = update_balance(
                    params["caller_num"], int(float(params["amount"])),
                    auth.username,
                    "moins"
                    )
                if account_new["status"] == 200:
                    # Activation du produit
                    data = {
                        'session': '',
                        "operator": "bip",
                        "caller_num": params["caller_num"],
                        "service_type": "izytv",
                        "client_refnum": customer['message']['client_refnum'],
                        "device_id": login,
                        "solde": params["amount"],
                        "offre_refnum": params["offer_id"],
                        "partner_ref": "BIP"
                        }
                    LOGS.logger.info("Activation du produit")
                    LOGS.logger.info("data: "+json.dumps(data))
                    response = izytv_buy_recharge(data)
                    # Activation offre NON OK
                    if response["status"] != 200:
                        response = {
                            "code": "044-05-{}".format(
                                response["status"]
                                ),
                            "info": "Activation du produit",
                            "message": """Problème à atteindre """
                            """le serveur bluebase""",
                            "status": response["status"],
                        }
                        LOGS.logger.info(response)
                        message = MESSAGE[lg]["400"]
                        data_sms = {
                            "msisdn": params["caller_num"],
                            "message": message
                        }
                        send_sms(data_sms)
                        # Roll back du solde du client
                        account_new = update_balance(
                            params["caller_num"],
                            int(float(params["amount"])),
                            auth.username,
                            "plus"
                            )
                        LOGS.logger.info(account_new)
                    # Activation offre OK
                    elif response["status"] == 200:
                        response = {
                            "code": "044-05-200",
                            "info": "Activation du produit",
                            "message": "Activation successful",
                            "status": response["status"]
                        }
                        LOGS.logger.info(response)
                        message = MESSAGE[lg]["200"]+str(params['bundle_name'])
                        data_sms = {
                            "msisdn": params["caller_num"],
                            "message": message
                            }
                        send_sms(data_sms)
                else:
                    message = MESSAGE[lg]["400"]
                    data_sms = {
                        "msisdn": params["caller_num"],
                        "message": message
                        }
                    send_sms(data_sms)
                    response = account_new
                    LOGS.logger.info(response)
            else:
                message = MESSAGE[lg]["400"]
                data_sms = {"msisdn": params["caller_num"], "message": message}
                send_sms(data_sms)
                response = {
                    "code": "044-05-{}".format(response["status"]),
                    "info": "Récuperation de l'info du client",
                    "message": "Problème à atteindre le serveur 4D",
                    "status": response["status"],
                }
                LOGS.logger.info(response)
        else:
            message = MESSAGE[lg]["401"]
            data_sms = {"msisdn": params["caller_num"], "message": message}
            send_sms(data_sms)
            LOGS.logger.info(data_sms)
            response = balance
            LOGS.logger.info(response)
    else:
        message = MESSAGE[lg]["400"]
        data_sms = {"msisdn": params["caller_num"], "message": message}
        send_sms(data_sms)
        response = balance
        response = bad_request(
            service_code=SERVICE_CODE, code=response["status"]
            )
    return jsonify(response)


@api.route('/customer/register/bluebase', methods=['POST'])
def customerRegisterBluebase():
    """
    enregistre le profil du client dans bluebase.
    ---
    tags:
      - Authentication
    components:
      securitySchemes:
        basicAuth:
          type: http
          scheme: basic
    security:
      - basicAuth: []
    parameters:
      - name: login
        in: body
        required: true
        description: identifiant motv du client
        schema:
          type: string
      - name: last_name
        in: body
        required: true
        description: nom du client
        schema:
          type: string
      - name: first_name
        in: body
        required: true
        description: prenom
        schema:
          type: string
      - name: phone
        in: body
        required: true
        description: numero de telephone
        schema:
          type: string
          enum:
            - 039
            - 032
            - 034
            - 033
      - name: birthday
        in: body
        required: true
        description: date de naissance
        schema:
          type: date
      - name: mail
        in: body
        required: true
        description: adresse mail
        schema:
          type: string
      - name: pseudo
        in: body
        required: true
        description: prenom
        schema:
          type: string
      - name: pin
        in: body
        required: true
        description: code pin du client motv
        schema:
          type: string
    """
    data = request.get_json()
    try:
        result = customer_register(data)
    except SyntaxError:
        return bad_request(message="paramètres incorrect", code="040-05-400")
    else:
        return jsonify(result)


@api.route('/customer/register/bluebase', methods=['PUT'])
def customerUpdateBluebase():
    """
    enregistre le profil du client dans bluebase.
    ---
    tags:
      - Authentication
    components:
      securitySchemes:
        basicAuth:
          type: http
          scheme: basic
    security:
      - basicAuth: []
    parameters:
      - name: last_name
        in: body
        required: true
        description: nom du client
        schema:
          type: string
      - name: first_name
        in: body
        required: true
        description: prenom
        schema:
          type: string
      - name: phone
        in: body
        required: true
        description: numero de telephone
        schema:
          type: string
          enum:
            - 039
            - 032
            - 034
            - 033
      - name: birthday
        in: body
        required: true
        description: date de naissance
        schema:
          type: date
      - name: mail
        in: body
        required: true
        description: adresse mail
        schema:
          type: string
    """
    data = request.get_json()
    pwd = data.get('password', None)
    try:
        if not pwd:
            result = customer_update(data)
        else:
            result = customer_notif(data)
    except SyntaxError:
        return bad_request(message="paramètres incorrect", code="040-05-400")
    else:
        return jsonify(result)


# MW

# @api.route('/customer/getdata', methods=['GET'])
# def customerGetData():
#     timestamp, x = (str((datetime.datetime.now()).timestamp())).split('.')
#     token = hashing(timestamp, MOTV_LOGIN, MOTV_PSW)
#     headers = {
#             'Authorization-user': (
#                 '{login}:{timestamp}:{token}'.format(
#                     login=MOTV_LOGIN,
#                     timestamp=timestamp,
#                     token=token
#                     )
#                 ),
#         }
#     data = request.get_json()
#     data["data"] = data.pop("data1")
#     data.get('data')['customersId'] = int(data.get('data')['customersId'])
#     data = json.dumps(data)
#     response = requests.post(
#         '{uri}/customer/getData'.format(uri=MOTV_URI),
#         headers=headers,
#         data=data
#         )
#     response = response.json()
#     return jsonify(response)


# @api.route('/customer/register', methods=['POST'])
# def customerRegister():
#     timestamp, x = (str((datetime.datetime.now()).timestamp())).split('.')
#     token = hashing(timestamp, MOTV_LOGIN, MOTV_PSW)
#     headers = {
#             'Authorization-user': (
#                 '{login}:{timestamp}:{token}'.format(
#                     login=MOTV_LOGIN,
#                     timestamp=timestamp,
#                     token=token
#                     )
#                 ),
#         }
#     data = request.get_json()
#     data["data"] = data.pop("data1")
#     data["data"]["data"] = data["data"].pop("data2")
#     data = json.dumps(data)
#     response = requests.post(
#         '{uri}/customer/register'.format(uri=MOTV_URI),
#         headers=headers,
#         data=data
#         )
#     response = response.json()
#     return jsonify(response)


# @api.route('/customer/update', methods=['PUT'])
# def customerUpdate():

#     timestamp, x = (str((datetime.datetime.now()).timestamp())).split('.')
#     token = hashing(timestamp, MOTV_LOGIN, MOTV_PSW)
#     headers = {
#             'Authorization-user': (
#                 '{login}:{timestamp}:{token}'.format(
#                     login=MOTV_LOGIN,
#                     timestamp=timestamp,
#                     token=token
#                     )
#                 ),
#         }
#     data = request.get_json()
#     data["data"] = data.pop("data1")
#     data["data"]["data"] = data["data"].pop("data2")
#     data.get('data')['customersId'] = int(data.get('data')['customersId'])
#     data = json.dumps(data)
#     response = requests.post(
#         '{uri}/customer/update'.format(uri=MOTV_URI),
#         headers=headers,
#         data=data
#         )
#     response = response.json()
#     return jsonify(response)


# @api.route('/customer/delete', methods=['POST'])
# def customerDelete():
#     timestamp, x = (str((datetime.datetime.now()).timestamp())).split('.')
#     token = hashing(timestamp, MOTV_LOGIN, MOTV_PSW)
#     headers = {
#             'Authorization-user': (
#                 '{login}:{timestamp}:{token}'.format(
#                     login=MOTV_LOGIN,
#                     timestamp=timestamp,
#                     token=token
#                     )
#                 ),
#         }
#     data = request.get_json()
#     data["data"] = data.pop("data1")
#     data.get('data')['customersId'] = int(data.get('data')['customersId'])
#     data = json.dumps(data)
#     response = requests.post(
#         '{uri}/customer/delete'.format(uri=MOTV_URI),
#         headers=headers,
#         data=data
#         )
#     response = response.json()
#     return jsonify(response)


# @api.route('/customer/profile/getProfiles', methods=['GET'])
# def customergetProfiles():
#     timestamp, x = (str((datetime.datetime.now()).timestamp())).split('.')
#     token = hashing(timestamp, MOTV_LOGIN, MOTV_PSW)
#     headers = {
#             'Authorization-user': (
#                 '{login}:{timestamp}:{token}'.format(
#                     login=MOTV_LOGIN,
#                     timestamp=timestamp,
#                     token=token
#                     )
#                 ),
#         }
#     data = request.get_json()
#     data["data"] = data.pop("data1")
#     data.get('data')['customersId'] = int(data.get('data')['customersId'])
#     data = json.dumps(data)
#     response = requests.post(
#         '{uri}/profile/getProfiles'.format(uri=MOTV_URI),
#         headers=headers,
#         data=data
#         )
#     response = response.json()
#     return jsonify(response)


# @api.route('/customer/profile/update', methods=['PUT'])
# def customergetUpdateProfile():
#     timestamp, x = (str((datetime.datetime.now()).timestamp())).split('.')
#     token = hashing(timestamp, MOTV_LOGIN, MOTV_PSW)
#     headers = {
#             'Authorization-user': (
#                 '{login}:{timestamp}:{token}'.format(
#                     login=MOTV_LOGIN,
#                     timestamp=timestamp,
#                     token=token
#                     )
#                 ),
#         }
#     data = request.get_json()
#     data["data"] = data.pop("data1")
#     data["data"]["data"] = data["data"].pop("data2")
#     data.get('data')['profilesId'] = int(data.get('data')['profilesId'])
#     data = json.dumps(data)
#     response = requests.post(
#         '{uri}/profile/update'.format(uri=MOTV_URI),
#         headers=headers,
#         data=data
#         )
#     response = response.json()
#     return jsonify(response)


# @api.route('/customer/getDevices', methods=['GET'])
# def customerGetDevices():
#     timestamp, x = (str((datetime.datetime.now()).timestamp())).split('.')
#     token = hashing(timestamp, MOTV_LOGIN, MOTV_PSW)
#     headers = {
#             'Authorization-user': (
#                 '{login}:{timestamp}:{token}'.format(
#                     login=MOTV_LOGIN,
#                     timestamp=timestamp,
#                     token=token
#                     )
#                 ),
#         }
#     data = request.get_json()
#     data["data"] = data.pop("data1")
#     data.get('data')['customersId'] = int(data.get('data')['customersId'])
#     data = json.dumps(data)
#     response = requests.post(
#         '{uri}/device/getDevices'.format(uri=MOTV_URI),
#         headers=headers,
#         data=data
#         )
#     response = response.json()
#     return jsonify(response)


# @api.route('/customer/getPackageSubscriptions', methods=['GET'])
# def gitgetPackageSubscriptions():
#     timestamp, x = (str((datetime.datetime.now()).timestamp())).split('.')
#     token = hashing(timestamp, MOTV_LOGIN, MOTV_PSW)
#     headers = {
#             'Authorization-user': (
#                 '{login}:{timestamp}:{token}'.format(
#                     login=MOTV_LOGIN,
#                     timestamp=timestamp,
#                     token=token
#                     )
#                 ),
#         }
#     data = request.get_json()
#     data["data"] = data.pop("data1")
#     data.get('data')['customersId'] = int(data.get('data')['customersId'])
#     data = json.dumps(data)
#     response = requests.post(
#         '{uri}/subscription/getPackageSubscriptions'.format(uri=MOTV_URI),
#         headers=headers,
#         data=data
#         )
#     response = response.json()
#     return jsonify(response)


# @api.route('/customer/subscribePackage', methods=['POST'])
# def subscribePackage():
#     timestamp, x = (str((datetime.datetime.now()).timestamp())).split('.')
#     token = hashing(timestamp, MOTV_LOGIN, MOTV_PSW)
#     headers = {
#             'Authorization-user': (
#                 '{login}:{timestamp}:{token}'.format(
#                     login=MOTV_LOGIN,
#                     timestamp=timestamp,
#                     token=token
#                     )
#                 ),
#         }
#     data = request.get_json()
#     data["data"] = data.pop("data1")
#     data.get('data')['customersId'] = int(data.get('data')['customersId'])
#     data.get('data')['packagesId'] = int(data.get('data')['packagesId'])
#     data = json.dumps(data)
#     response = requests.post(
#         '{uri}/subscription/subscribePackage'.format(uri=MOTV_URI),
#         headers=headers,
#         data=data
#         )
#     response = response.json()
#     return jsonify(response)


# @api.route('/customer/cancelPackage', methods=['POST'])
# def cancelPackage():
#     timestamp, x = (str((datetime.datetime.now()).timestamp())).split('.')
#     token = hashing(timestamp, MOTV_LOGIN, MOTV_PSW)
#     headers = {
#             'Authorization-user': (
#                 '{login}:{timestamp}:{token}'.format(
#                     login=MOTV_LOGIN,
#                     timestamp=timestamp,
#                     token=token
#                     )
#                 ),
#         }
#     data = request.get_json()
#     data["data"] = data.pop("data1")
#     data.get('data')['customersId'] = int(data.get('data')['customersId'])
#     data.get('data')['packagesId'] = int(data.get('data')['packagesId'])
#     data = json.dumps(data)
#     response = requests.post(
#         '{uri}/subscription/cancelPackage'.format(uri=MOTV_URI),
#         headers=headers,
#         data=data
#         )
#     response = response.json()
#     return jsonify(response)


# @api.route('/device/getdata', methods=['GET'])
# def deviceGetData():
#     timestamp, x = (str((datetime.datetime.now()).timestamp())).split('.')
#     token = hashing(timestamp, MOTV_LOGIN, MOTV_PSW)
#     headers = {
#             'Authorization-user': (
#                 '{login}:{timestamp}:{token}'.format(
#                     login=MOTV_LOGIN,
#                     timestamp=timestamp,
#                     token=token
#                     )
#                 ),
#         }
#     data = request.get_json()
#     data["data"] = data.pop("data1")
#     data.get('data')['devicesId'] = int(data.get('data')['devicesId'])
#     data = json.dumps(data)
#     response = requests.post(
#         '{uri}/device/getData'.format(uri=MOTV_URI),
#         headers=headers,
#         data=data
#         )
#     response = response.json()
#     return jsonify(response)


# @api.route('/device/addDevice', methods=['POST'])
# def deviceAddDevice():
#     timestamp, x = (str((datetime.datetime.now()).timestamp())).split('.')
#     token = hashing(timestamp, MOTV_LOGIN, MOTV_PSW)
#     headers = {
#             'Authorization-user': (
#                 '{login}:{timestamp}:{token}'.format(
#                     login=MOTV_LOGIN,
#                     timestamp=timestamp,
#                     token=token
#                     )
#                 ),
#         }
#     data = json.dumps(request.get_json())
#     response = requests.post(
#         '{uri}/device/addDevice'.format(uri=MOTV_URI),
#         headers=headers,
#         data=data
#         )
#     response = response.json()
#     return jsonify(response)


# @api.route('/device/removeDevice', methods=['POST'])
# def deviceRemoveDevice():
#     timestamp, x = (str((datetime.datetime.now()).timestamp())).split('.')
#     token = hashing(timestamp, MOTV_LOGIN, MOTV_PSW)
#     headers = {
#             'Authorization-user': (
#                 '{login}:{timestamp}:{token}'.format(
#                     login=MOTV_LOGIN,
#                     timestamp=timestamp,
#                     token=token
#                     )
#                 ),
#         }
#     data = request.get_json()
#     data["data"] = data.pop("data1")
#     data.get('data')['devicesId'] = int(data.get('data')['devicesId'])
#     data = json.dumps(data)
#     response = requests.post(
#         '{uri}/device/removeDevice'.format(uri=MOTV_URI),
#         headers=headers,
#         data=data
#         )
#     response = response.json()
#     return jsonify(response)
