#!/usr/bin/env python
# encoding: utf-8

from ..motv import Customer
from ..client import Client
from . import app
import click
import time


@click.group()
def cmd():
    pass


@cmd.command()
def sync_customers():
    customer = Customer()
    customers = customer.all_customer()
    time.sleep(3)
    for personne in customers:
        print(personne['Login'])
        if personne['Login'] == "jakub2@motv.eu":
            pass
        else:
            customer.login = personne['Login']
            data = customer.getDataByLogin()
            print(data)
            customerid = data["response"]["customers_id"]
            viewers_id = data["response"]["device_motv_viewers_id"]
            client = Client(
                customerid,
                viewers_id,
                personne['Login'],
                personne['Firstname'],
                personne['Lastname'],
                personne['Packages'],
                personne['Created']
                )
            result = client.select()
            if result:
                client.update()
                print("Update " + personne['Login'])
            else:
                client.create()
                print("Insert " + personne['Login'])


@cmd.command()
@click.option('--host', default='127.0.0.1')
@click.option('--port', default=5000)
def runserver(host, port):
    app.run(
        host=host,
        port=port,
        debug=True
        )

# EOF
