#!/usr/bin/env python
# encoding: utf-8


import json
import requests
from .consts import NOTIFICATION_URL


DESTINATION = [
    "luca.manjatoarisaona@staff.blueline.mg",
    "fabrice.djoko@staff.blueline.mg",
    "dev@si.blueline.mg",
    "rahim.remtola@staff.blueline.mg",
    "abdoul.beanjara@staff.blueline.mg"
    ]


class Notification(object):

    def __init__(self, service, request, params, message):
        self.service = service
        self.request = request
        self.params = params
        self.message = message

    def send(self, destination):
        text = ('Erreur IzyTv' + '\n' + "REQUEST: {service}-".format(
                service=self.service
                ) + self.request + '\n' + "PARAMS: " + json.dumps(
                self.params
                ) + '\n' + "MESSAGE: " + self.message
                )
        data = {
            'mail_to': DESTINATION,
            'mail_from': 'izytv@blueline.mg',
            'mail_text': text,
            'title': 'IzyTv'
            }
        response = requests.post(
            '{}/api/send/email/'.format(NOTIFICATION_URL),
            params=data
            )
        return response
# EOF
