# -*- coding: utf-8 -*-

from . import core


class CashRechargeMgr(core.OCSInterface):
    def Payment(self, sender, phonenumber, amount, **kwargs):

        data = {
            "AgentName": sender,
            "SubscriberNo": phonenumber,
            "AccountType": 2000,
            "PaymentMode": 0,
            "PaymentAmt": amount,
            "RechargeRuleID": kwargs.get("recharge_rule", "UNKNOWN"),
            "AdditionalInfo": kwargs.get("infos", "None"),
        }
        for key, value in kwargs.items():
            data[key] = value
        code, result = self.call_ocs("Payment", data, "PaymentResult")
        return code, result
