# -*- coding: utf-8 -*-

from .consts import ODOO_CLIENT
from .consts import API_LOGS
from .consts import ODOO_URI, db, username, password
from xmlrpc import client


class Locations(object):

    def __init__(self, location_id=None):
        self.location_id = location_id
        self.data = {
            "jsonrpc": "2.0",
            "params": {}
            }

    def stock_by_location(self):
        response = ODOO_CLIENT.get(
            '/stocks/picking/stock_by_location/{}'.format(self.location_id)
        )
        # response = response.json()
        return response

    @staticmethod
    def create(name, usage, location_id):
        data = {
            "jsonrpc": "2.0",
            "params": {
                "vals": {
                    "name": name,
                    "usage": usage,
                    "location_id": location_id
                    }
                }
            }
        response = ODOO_CLIENT.post('/stocks/locations', json=data)
        if 'request_id' in response['content']:
            return Locations(response['content']['request_id'])
        else:
            return False

    @staticmethod
    def all():
        response = ODOO_CLIENT.get('/stocks/locations')
        return response

    def shop(self):
        response = ODOO_CLIENT.get('/shop')
        if response.status == 200:
            response = response.json()
            response = {
                "status": response["status"],
                "info": "Liste de chops",
                "data": response
                }
        else:
            response = {
                "status": response.status_code,
                "message": "Erreur",
                }

        return response


class PickingRequest(object):

    def __init__(self, request_id=None):
        self.request_id = request_id

    def status(self):
        # response = ODOO_CLIENT.get(
        #     '/stocks/picking/requests/{}'.format(self.request_id)
        #     )
        # API_LOGS.logger.info(response)
        common = client.ServerProxy(
            '{}/xmlrpc/2/common'.format(ODOO_URI)
        )
        uid = common.authenticate(db, username, password, {})
        models = client.ServerProxy('{}/xmlrpc/2/object'.format(ODOO_URI))
        record = models.execute_kw(
                db,
                uid,
                password,
                'stock.picking',
                'search_read',
                [
                    [
                        ['id', '=', self.request_id],
                    ]
                ],
                {
                    'fields': []
                }
            )
        if record:
            record = record[0]
        API_LOGS.logger.info(record)
        return record

    def update(self, data):
        response = ODOO_CLIENT.put(
            '/stocks/picking/requests/{}'.format(self.request_id),
            json=data
            )
        return response

    @staticmethod
    def create(data):
        params = data
        params["company_id"] = int(params["company_id"])
        params["location_id"] = int(params["location_id"])
        params["location_dest_id"] = int(params["location_dest_id"])
        params["picking_type_id"] = int(params["picking_type_id"])
        if type(params["move_lines"]) != list:
            params["move_lines"] = [params["move_lines"]]
        API_LOGS.logger.info(params)
        for move in params["move_lines"]:
            move["location_id"] = params["location_id"]
            move["location_dest_id"] = params["location_dest_id"]
            move["company_id"] = params["company_id"]
            move["date"] = params["date"]
            move["date_expected"] = params["date"]
            move["serial_number"] = [move["serial_number"]]
            move["name"] = params["name"]
            move["product_uom"] = 1
            move["product_uom_qty"] = 1
            move["procure_method"] = "make_to_stock"
            move["product_id"] = int(move["product_id"])

        params.pop("date")
        params.pop("name")
        data = {
            "jsonrpc": "2.0",
            "params": {
                "vals": params
                }
            }
        response = ODOO_CLIENT.post(
            '/stocks/picking/requests', json=data
            )
        return response

    @staticmethod
    def return_picking(data):
        response = ODOO_CLIENT.post(
            '/stocks/picking/retunr_picking', json=data
            )
        return response

    @staticmethod
    def entre_deux_date(start_date, end_date):
        response = ODOO_CLIENT.get(
            "/moves/{start_date}/{end_date}".format(
                start_date=start_date,
                end_date=end_date
                )
            )
        API_LOGS.logger.info(response)
        if response["status"] == 200:
            response = {
                "status": response["status"],
                "info": "Mouvement entre deux dates",
                "data": response["content"]
                }
        else:
            response = {
                "status": response["status"],
                "message": "Erreur",
                }

        return response

    @staticmethod
    def incoming(location_id):
        common = client.ServerProxy(
            '{}/xmlrpc/2/common'.format(ODOO_URI)
        )
        uid = common.authenticate(db, username, password, {})
        models = client.ServerProxy('{}/xmlrpc/2/object'.format(ODOO_URI))
        record = models.execute_kw(
                db,
                uid,
                password,
                'stock.picking',
                'search_read',
                [
                    [
                        ['location_dest_id', '=', location_id],
                        # ['picking_type_code', '=', 'internal'],
                        ['state', '!=', 'done'],
                        ['state', '!=', 'cancel'],
                    ]
                ],
                {
                    'fields': [
                        'id',
                        'name',
                        'create_date',
                        'state',
                        'location_dest_id',
                        'location_id'
                    ]
                }
            )
        API_LOGS.logger.info(record)
        return record

    @staticmethod
    def product_lot(location_id, product_id):
        common = client.ServerProxy(
            '{}/xmlrpc/2/common'.format(ODOO_URI)
        )
        uid = common.authenticate(db, username, password, {})
        models = client.ServerProxy('{}/xmlrpc/2/object'.format(ODOO_URI))
        record = models.execute_kw(
            db,
            uid,
            password,
            'stock.quant',
            'search_read',
            [
                [
                    ['location_id', '=', location_id],
                    ['product_id', '=', product_id],
                ]
            ],
            {
                'fields': ['lot_id']
            }
        )
        if record:
            res = []
            for i in record:
                res.append({'id': i['id'], 'lot_id': i['lot_id'][1]})
            record = res
        API_LOGS.logger.info(record)
        return record

    def validate(self):
        # common = client.ServerProxy(
        #     '{}/xmlrpc/2/common'.format(ODOO_URI)
        # )
        # uid = common.authenticate(db, username, password, {})
        # models = client.ServerProxy('{}/xmlrpc/2/object'.format(ODOO_URI))
        # record = models.execute_kw(
        #     db,
        #     uid,
        #     password,
        #     'stock.picking',
        #     'write',
        #     [
        #         [self.request_id],
        #         {'state': "done"}
        #     ]
        # )
        # API_LOGS.logger.info(record)
        # return record
        response = ODOO_CLIENT.get(
            '/stocks/picking/requests/validate/{}'.format(self.request_id)
            )
        API_LOGS.logger.info(response)
        if response["status"] == 200:
            if response["content"]['Code'] == 500:
                response = {
                    'status': 500,
                    'message': response["content"]['Error']
                    }
            else:
                response = {'status': 200, 'message': response["content"]}
        else:
            response = {'status': 500, 'message': response["content"]}
        API_LOGS.logger.info(response)
        return response

    def cancel(self):
        common = client.ServerProxy(
            '{}/xmlrpc/2/common'.format(ODOO_URI)
        )
        uid = common.authenticate(db, username, password, {})
        models = client.ServerProxy('{}/xmlrpc/2/object'.format(ODOO_URI))
        record = models.execute_kw(
            db,
            uid,
            password,
            'stock.picking',
            'write',
            [
                [self.request_id],
                {'state': "cancel"}
            ]
        )
        API_LOGS.logger.info(record)
        return record

# EOF
