#!/usr/bin/env python
# encoding: utf-8


import psycopg2
import datetime
from itertools import groupby
from .consts import ussd_partner


conn = psycopg2.connect(
    database=ussd_partner["database"],
    user=ussd_partner["user"],
    password=ussd_partner["password"],
    host=ussd_partner["host"],
    port=ussd_partner["port"]
    )


def get_record():
    cur = conn.cursor()
    # hier = datetime.date.today()-datetime.timedelta(1)
    start_date = datetime.datetime(2019, 5, 3, 00, 00, 00)
    # datetime.datetime(hier.year, hier.month, hier.day, 00, 00, 00)
    end_date = datetime.datetime(2019, 5, 3, 23, 59, 59)
    # datetime.datetime(hier.year, hier.month, hier.day, 23, 59, 59)
    query = """SELECT * from bip_transaction
     where datetime_req >= %(start_date)s and datetime_req <= %(end_date)s"""
    cur.execute(query, {'start_date': start_date, 'end_date': end_date})
    request = cur.fetchall()
    conn.close()

    request = sorted(request, key=lambda x: x[9])
    record = groupby(request, key=lambda x: x[9])
    dic = {}
    params = {}

    for i, k in record:
        dic[i] = list(k)

    for key, value in dic.items():
        m = 0
        params = {
            'partner_id': key,
            'description': value
            }
        for i in value:
            m += int(i[4])
        params['montant'] = m
        print(params)

# EOF
