#!/usr/bin/env python
# encoding: utf-8

from .consts import LOGS, DB_CREDENTIALS
import records


def database_url(**kwargs):
    """
    On aura besoin d'un database relationel
    pour enregistrer les activations d'offres
    bip via un partenaire. utile pour la compta
    odoo
    """
    url = "{eng}://{user}:{password}@{host}:{port}/{name}".format(
        eng=DB_CREDENTIALS["engine"],
        user=DB_CREDENTIALS["user"],
        password=DB_CREDENTIALS["password"],
        host=DB_CREDENTIALS["host"],
        port=DB_CREDENTIALS["port"],
        name=DB_CREDENTIALS["name"],
    )
    return url


def write_transaction_to_db(**kwargs):
    """
    """
    url = database_url(**DB_CREDENTIALS)
    sql = (
        "INSERT INTO webpayment_transaction ("
        "amount,"
        "operation_id,"
        "label,"
        "device_id,"
        "other,"
        "client_ref,"
        "offer_ref,"
        "partner_ref,"
        "date_transaction,"
        "status,"
        "operator,"
        "offer_name,"
        "caller_num,"
        "info) "
        "VALUES ("
        ":amount,"
        ":operation_id,"
        ":label,"
        ":device_id,"
        ":other,"
        ":client_ref,"
        ":offer_ref,"
        ":partner_ref,"
        ":date_transaction,"
        ":status,"
        ":operator,"
        ":offer_name,"
        ":caller_num,"
        ":info)"
    )
    with records.Database(url) as db:
        db.query(
            sql,
            amount=kwargs.get('amount'),
            operation_id=kwargs.get('operation_id'),
            label=kwargs.get('label'),
            device_id=kwargs.get('device_id'),
            other=kwargs.get('other'),
            client_ref=kwargs.get('client_ref'),
            offer_ref=kwargs.get('offer_ref'),
            partner_ref=kwargs.get('partner_ref'),
            date_transaction=kwargs.get('date_transaction'),
            status=kwargs.get('status'),
            operator=kwargs.get('operator'),
            offer_name=kwargs.get('offer_name'),
            caller_num=kwargs.get('caller_num'),
            info=kwargs.get('info'),
        )
