#!/usr/bin/env python
# encoding: utf-8

from .consts import LOGS, REDIS_DB
from .mvola import Mvola
from .orangemoney import OrangeMoney
from .bluebase import izytv_buy_recharge
from .core import write_transaction_to_db
import records
import json
import datetime


def decode(val):
    data = {key.decode('utf-8'): value.decode('utf-8') for (key, value) in val.items()}
    return data


class IzyTV(object):

    def __init__(self):
        self.all_transaction = REDIS_DB.keys()

    def activate_bouquet(self):
        for i in self.all_transaction:
            trans_timeout = 6
            transId = i.decode('utf-8')
            val = REDIS_DB.hgetall(i)
            data = decode(val)
            if data["status"] == "En attente de paiement" or data["info"] == "Activation en attente":
                if data["operator"] == "telma-izytv":
                    mvola = Mvola()
                    response = mvola.checkTransactionStatus(data["partner_ref"])
                    if response["status"] != 404:
                        if response["status"] == 200:
                            data["status"] = "Transaction validée"
                            params = {
                                'session': '',
                                "operator": data["operator"],
                                "caller_num": data["caller_num"],
                                "service_type": data["service_type"],
                                "client_refnum": data["client_refnum"],
                                "device_id": data["device_id"],
                                "solde": data["amount"],
                                "offre_refnum": data["offre_refnum"],
                                "partner_ref": data["partner_ref"]
                            }
                            LOGS.logger.info("data: " + json.dumps(params))
                            result = izytv_buy_recharge(params)
                            if result["status"] == 200:
                                LOGS.logger.info(result)
                                data["info"] = "Activation reussie"
                                REDIS_DB.hmset(transId, data)
                                # Mettre à jour la base postgres
                            else:
                                LOGS.logger.info(result)
                                # On réactivate plus tard
                        elif response["status"] == 2:  # Processus en cours
                            data["status"] = "Processus en cours"
                            REDIS_DB.hmset(transId, data)
                        elif response["status"] == 3:  # Transaction annulée coté telma
                            data["status"] = "Transaction annulée"
                            data["info"] = "Activation annulée"
                            REDIS_DB.hmset(transId, data)
                        elif response["status"] == 1:  # en attente
                            date = datetime.datetime.strptime(
                                data["TransactionDate"],
                                "%Y-%m-%d %H:%M:%S"
                            )
                            now = datetime.datetime.now()
                            if ((now - date).total_seconds() / 60.0) >= 6:
                                data["status"] = "Transaction annulée"
                                data["info"] = "Activation annulée"
                                REDIS_DB.hmset(transId, data)
                    else:
                        LOGS.logger.info(response)
                elif data["operator"] == "orange-izytv":
                    trans_info = {
                        'amount': data['amount'],
                        'order_id': data['order_id'],
                        'pay_token': data['partner_ref'],
                    }
                    response = OrangeMoney().checkTransactionStatus(trans_info)
                    LOGS.logger.info(response)
                    STATUS = {
                        4: "Transaction validée",
                        1: "Transaction en cours",
                        2: "Processus en cours",
                        3: "Transaction annulée",
                    }
                    rstatus = response['status']
                    data['status'] = STATUS[rstatus]
                    data['info'] = STATUS[rstatus]

                    if rstatus == 4:  # Succeeded
                        params = {
                            'session': '',
                            "operator": data["operator"],
                            "caller_num": data["caller_num"],
                            "service_type": data["service_type"],
                            "client_refnum": data["client_refnum"],
                            "device_id": data["device_id"],
                            "solde": data["amount"],
                            "offre_refnum": data["offre_refnum"],
                            "partner_ref": data["partner_ref"]
                        }
                        LOGS.logger.info("data: " + json.dumps(params))
                        result = izytv_buy_recharge(params)
                        if result["status"] == 200:
                            LOGS.logger.info(result)
                            data["info"] = "Activation reussie"
                    elif rstatus == 1:  # Pending
                        date = datetime.datetime.strptime(
                            data["TransactionDate"],
                            "%Y-%m-%d %H:%M:%S"
                        )
                        now = datetime.datetime.now()
                        if ((now - date).total_seconds() / 60.0) >= trans_timeout:
                            data["status"] = "Transaction annulée"
                            data["info"] = "Activation annulée"

                    # update Redis
                    REDIS_DB.hmset(transId, data)
                else:
                    LOGS.logger.info(response)

    def sort_data(self):
        data = []
        for i in self.all_transaction:
            val = REDIS_DB.hgetall(i)
            data.append(decode(val))
        sorted_data = sorted(data, key=lambda i: i['TransactionDate'])
        return sorted_data

    def writeToDB(self):
        for data in self.sort_data():
            if data["status"] == "Transaction validée" and data["info"] == "Activation reussie":
                try:
                    write_transaction_to_db(**data)
                except Exception as e:
                    error = e
                else:
                    error = "Successful"
                LOGS.logger.info("Ecriture transaction N° {}: {}".format(data["partner_ref"], error))

# EOF
