#!/usr/bin/env python
# encoding: utf-8

from ..izytv import IzyTV
from ..sage import Sage
from . import app
import click


@click.group()
def cmd():
    pass


@cmd.command()
def active_bouquet():
    izytv = IzyTV()
    izytv.activate_bouquet()


@cmd.command()
def writeToDB():
    izytv = IzyTV()
    izytv.writeToDB()


@cmd.command()
@click.option('--host', default='127.0.0.1')
@click.option('--port', default=5000)
def runserver(host, port):
    app.run(
        host=host,
        port=port,
        debug=True
    )


@cmd.command()
@click.option('--orangemoney', type=click.Choice(['True', 'False']))
@click.option('--mvola', type=click.Choice(['True', 'False']))
@click.option('--airtelmoney', type=click.Choice(['True', 'False']))
def insertTransactions(orangemoney, mvola, airtelmoney):
    sage = Sage(orangemoney, mvola, airtelmoney)
    sage.startAccounting()

# EOF
