#!/usr/bin/env python
# encoding: utf-8

import datetime
import xmltodict
from zeep import Client
from .consts import CONFIG, LOGS, MVOLA, REDIS_DB, SERVICE_CODE


class Mvola(object):
    """
    une classe pour les requêtes à destination de l'api Mvola de telma
    """
    def __init__(self):
        self.url = MVOLA["url"]

    def paymentRequest(self, data):
        params = {
            "Login_WS": MVOLA["login"],
            "Password_WS": MVOLA["pwd"],
            "HashCode_WS": MVOLA["hashcode"],
            "ShopTransactionAmount": int(data["amount"]),
            "ShopTransactionID": int(data["operation_id"]),
            "ShopTransactionLabel": data["label"],
            "ShopShippingName": data["device_id"],
            "ShopShippingAddress": data["other"]
        }
        try:
            LOGS.logger.info("Payment request, let's go")
            mvola_client = Client(self.url)
            response = mvola_client.service.WS_MPGw_PaymentRequest(
                MVOLA["apiversion"],
                params
            )
        except Exception as e:
            LOGS.logger.info(e)
            response = {
                "code": "{}-404".format(SERVICE_CODE),
                "response": {},
                "message": "Serveur Mvola introuvable",
                "status": 404
            }
        else:
            if ('Error' in response["MPGw_TokenID"] or response["ResponseCode"] != 0):
                response = {
                    "code": "{}-{}".format(SERVICE_CODE, response["ResponseCode"]),
                    "response": {
                        "ResponseCode": response["ResponseCode"],
                        "ResponseCodeDescription": response["ResponseCodeDescription"],
                        "MPGw_TokenID": response["MPGw_TokenID"]
                    },
                    "message": response["ResponseCodeDescription"],
                    "status": response["ResponseCode"],
                }
            else:
                mydate = datetime.datetime.today()
                transaction_date = mydate.strftime("%Y-%m-%d %H:%M:%S")
                data["TransactionDate"] = transaction_date
                data["operator"] = "telma-izytv"
                data["caller_num"] = "346042853"
                data["service_type"] = "izytv"
                data["partner_ref"] = response["MPGw_TokenID"]
                data["status"] = "En attente de paiement"
                data["info"] = "Activation en attente"
                redis_key = "request:payment:{}".format(response["MPGw_TokenID"])
                REDIS_DB.hmset(redis_key, data)
                # REDIS_DB.expire(redis_key, 86400)
                response = {
                    "code": "{}-200".format(SERVICE_CODE),
                    "response": {
                        "ResponseCode": response["ResponseCode"],
                        "ResponseCodeDescription": response["ResponseCodeDescription"],
                        "MPGw_TokenID": response["MPGw_TokenID"]
                    },
                    "message": response["ResponseCodeDescription"],
                    "status": 200,
                }
                # Sauvegarder dans redis
        LOGS.logger.info(response)
        return response

    def checkTransactionStatus(self, tokenId):
        params = {
            "Login_WS": MVOLA["login"],
            "Password_WS": MVOLA["pwd"],
            "HashCode_WS": MVOLA["hashcode"],
            "MPGw_TokenID": tokenId
        }
        try:
            mvola_client = Client(self.url)
            response = mvola_client.service.WS_MPGw_CheckTransactionStatus(
                MVOLA["apiversion"],
                params
            )
        except Exception as e:
            LOGS.logger.info(e)
            code = "{}-404".format(SERVICE_CODE)
            ResponseCode = None
            MvolaTransactionStatus = None
            TransactionStatusCode = None
            TransactionStatusDescription = None
            MvolaTransactionID = None
            message = "Serveur Mvola introuvable"
            status = 404
        else:
            if response["ResponseCode"] != 0:
                code = "{}-{}".format(SERVICE_CODE, response["ResponseCode"])
                ResponseCode = response["ResponseCode"]
                MvolaTransactionStatus = response["MvolaTransactionStatus"]
                TransactionStatusCode = response["TransactionStatusCode"]
                TransactionStatusDescription = response["TransactionStatusDescription"]
                MvolaTransactionID = tokenId
                message = response["ResponseCodeDescription"]
                status = response["ResponseCode"]
            else:
                if response["TransactionStatusCode"] == 4:
                    status = 200
                    MvolaTransactionID = response["MvolaTransactionID"]
                else:
                    status = response["TransactionStatusCode"]
                    MvolaTransactionID = tokenId
                code = "{}-{}".format(SERVICE_CODE, status)
                ResponseCode = response["ResponseCode"]
                MvolaTransactionStatus = response["MvolaTransactionStatus"]
                TransactionStatusCode = response["TransactionStatusCode"]
                TransactionStatusDescription = response["TransactionStatusDescription"]
                message = response["ResponseCodeDescription"]
        response = {
            "code": code,
            "response": {
                "MPGw_TokenID": tokenId,
                "ResponseCode": ResponseCode,
                "MvolaTransactionStatus": MvolaTransactionStatus,
                "TransactionStatusCode": TransactionStatusCode,
                "TransactionStatusDescription": TransactionStatusDescription,
                "MvolaTransactionID": MvolaTransactionID
            },
            "message": message,
            "status": status
        }
        LOGS.logger.info(response)
        return response

    def checkRedis(self, tokenId):
        redis_key = "request:payment:{}".format(tokenId)
        val = REDIS_DB.hgetall(redis_key.encode('utf-8'))
        data = {key.decode('utf-8'): value.decode('utf-8') for (key, value) in val.items()}
        if data:
            response = {
                "code": 200,
                "response": {
                    "order_id": data["partner_ref"]
                },
                "message": data["info"],
                "status": data["status"]
            }
        else:
            response = {
                "code": 400,
                "response": {
                    "order_id": "None"
                },
                "message": "L'operation_id n'existe pas dans la base",
                "status": "400"
            }
        return response

# EOF
