#!/usr/local/bin python
# encoding: utf-8

import requests
import xmltodict
from zeep import Client
from .consts import LOGS, PAYLOAD, WSDL_4D


def izytv_buy_recharge(data):
    LOGS.logger.info("Izytv buy offer")
    payload = PAYLOAD
    payload['root']['header']['param1'] = 'ussd_buy_recharge'
    payload['root']['data'] = data
    LOGS.logger.info(payload)
    try:
        LOGS.logger.info("Let's go")
        bluebase_client = Client(WSDL_4D)
        response = bluebase_client.service.S4D(xmltodict.unparse(payload))
        LOGS.logger.info(response)
    except Exception:
        response = {
            "code": "040-06-404",
            "message": "Serveur 4D introuvable",
            "status": 404,
        }
        LOGS.logger.info("Faild :( !!!")
        LOGS.logger.info(response)
    else:
        response = xmltodict.parse(response)
        if response['root']['header'].get("errorNum") == '0':
            if response['root']['data'].get('error'):
                response = {
                    "code": "040-06-{}".format(
                        response['root']['data']['error_num']
                    ),
                    "message": response['root']['data'],
                    "status": int(response['root']['data']['error_num']),
                }
                LOGS.logger.info(response)
            elif response['root']['data'].get('errorNum'):
                response = {
                    "code": "040-06-{}".format(
                        response['root']['data']['error_num']
                    ),
                    "message": "Recharge faild :( ",
                    "status": int(response['root']['data']['error_num']),
                }
                LOGS.logger.info(response)
            else:
                response = {
                    "code": "040-06-200",
                    "message": "Recharge successfully :) ",
                    "status": 200,
                }
                LOGS.logger.info(response)
        elif response['root']['header'].get("errorNum") != '0':
            response = {
                "code": "040-06-{}".format(
                    response['root']['header']["errorNum"]
                ),
                "message": response['root']['header']['errorTx'],
                "status": int(response['root']['header']["errorNum"]),
            }
            LOGS.logger.info(response)

    return response

# EOF
