# -*- coding: utf-8 -*-

from mmpy_bot.bot import respond_to

from ..consts import get_token, LOGS

import requests


@respond_to('shadok (.*)')
def call_jabberbot_cmd(message, cmd):
    """Cette fonction permet d'appeler les commandes de bot-services"""
    token = get_token()
    user = message.get_user_mail()
    LOGS.logger.info(user)
    try:
        response = requests.post(
            url='http://jabberbot.malagasy.com:5470',
            auth=(token, ''),
            json={
                'user': user,
                'cmd': cmd
                }
            )
    except Exception:
        message.reply("Erreur de connection a l'API JSON RPC des bots")
    else:
        result = response.json()
        message.reply(result['message'])
