#!/usr/bin/env python
# encoding: utf-8

from .core import Sms

import json
import threading

import pika
import redis


def process(queue):
    """Traitement des files d'attentes"""
    connection = pika.BlockingConnection(
        pika.ConnectionParameters(
            host='localhost',
            virtual_host='/simbank'
            )
        )
    channel = connection.channel()
    channel.basic_qos(prefetch_count=1)
    channel.basic_consume(Callback.call, queue=queue)
    channel.start_consuming()


class Worker(threading.Thread):

    def __init__(self, name, arg):
        threading.Thread.__init__(self)
        self.name = name
        self.arg = arg

    def run(self):
        process(self.arg)


class Callback(object):

    def __init__(self, method, uri, **kwargs):
        self.method = method.upper()
        self.uri = uri
        self.queue = '{}.simbank'.format(self.method)
        self.action = '{} {}'.format(
            self.method,
            self.uri
            )
        self.channel = kwargs.get('channel')

    @staticmethod
    def call(ch, method, properties, body):
        document = eval(body)
        http_verb = document['method']
        http_uri = document['uri']
        callback = Callback(http_verb, http_uri, channel=ch)
        if callback.action == 'POST /sms':
            if ',' in document['json']['destination']:
                callback.requeue_bulk_sms(document)
            else:
                callback.send_sms(document)
        ch.basic_ack(delivery_tag=method.delivery_tag)

    def send_sms(self, document):
        """Envoi d'un SMS"""
        source = document['json']['source']
        destination = document['json']['destination']
        message = document['json']['message']
        client = Sms(source, destination, message)
        response = client.send(document['headers'])
        status_code = response['status']
        result = response['content']
        infos = {
            'status': status_code,
            'content': result
            }
        key = 'simbank:{request_id}'.format(
            request_id=document['headers']['X-Request-Id']
            )
        if 'index' in document:
            key += ':{}'.format(document['index'])
        REDIS_SERVER = redis.Redis()
        REDIS_SERVER.hmset(key, infos)

    def requeue_bulk_sms(self, document):
        """Pour chaque numéro dans la liste
        on remet une requête d'envoi de SMS dans la file d'attente"""
        destinations = document['destination'].replace(' ', '')
        destinations = destinations.split(',')
        for index, destination in enumerate(destinations):
            bar = {
                'message': document['message'],
                'destination': destination
                }
            data = {
                key: value for key, value in document.items()
                if key != 'json'
                }
            data['json'] = bar
            data['index'] = index
            self.channel.basic_publish(
                exchange='async_requests',
                routing_key=self.queue,
                body=json.dumps(data),
                properties=pika.BasicProperties(delivery_mode=2)
                )

# EOF
