#!/usr/bin/env python
# encoding: utf-8


from rest_client import RestClient

from .consts import CONFIG

__all__ = [
    'Sms'
    ]


class Sms(object):

    def __init__(self, source, destination, message):
        self.source = source
        self.destination = destination
        self.message = message

    def __repr__(self):
        return '<Sms From: {}, To: {}>'.format(self.source, self.destination)

    def send(self, headers):
        """Envoi du SMS au Simbank"""

        data = {
            'src': self.source,
            'dst': self.destination,
            'msg': self.message
            }
        client = RestClient(CONFIG['AIGUILLIER']['url'])
        response = client.post(
            '/notifications/sms',
            auth=(
                CONFIG['AIGUILLIER']['username'],
                CONFIG['AIGUILLIER']['password']
                ),
            headers=headers,
            json=data
            )
        return response

    @staticmethod
    def send_multiple(messages):
        """Envoi de plusieurs SMS au Simbank"""

        short_messages = [Sms(*args) for args in messages]
        # on peut penser à envoyer vers une file d'attente,
        # mais pour le moment on va faire du séquentiel
        # et on ne gère pas les retours
        for short_message in short_messages:
            short_message.send()

# EOF
