#!/usr/bin/env python
# encoding: utf-8

from .consts import *  # NOQA
from .client import *  # NOQA
from .amqp_worker import *  # NOQA

import pika

connection = pika.BlockingConnection(
    pika.ConnectionParameters(
        host='localhost',
        virtual_host='/smsc'
        )
    )

channel = connection.channel()

channel.exchange_declare(exchange='async_requests', exchange_type='topic')

channel.queue_declare(queue='GET.smsc', durable=True)
channel.queue_bind(exchange='async_requests', queue='GET.smsc')

channel.queue_declare(queue='POST.smsc', durable=True)
channel.queue_bind(exchange='async_requests', queue='POST.smsc')

channel.queue_declare(queue='PUT.smsc', durable=True)
channel.queue_bind(exchange='async_requests', queue='PUT.smsc')

channel.queue_declare(queue='DELETE.smsc', durable=True)
channel.queue_bind(exchange='async_requests', queue='DELETE.smsc')

connection.close()

# EOF
