#!/usr/bin/env python
# encoding: utf-8

from blueflask.flask_api import app

from .v1 import api
from .v1 import __version__
from ..consts import API_REGISTRY
from ..consts import LOGS
from ..consts import HOSTNAME
from ..consts import SERVICE_CODE


app.config['LOGGER_NAME'] = 'smsc-services-api'
app.config['TITLE'] = 'API SMSC'
app.config['DESCRIPTION'] = "Communications SMPP avec le SMSC"
app.config['VERSION'] = __version__
app.logger.handlers = LOGS.logger.handlers
app.register_blueprint(api)


API_REGISTRY.hmset(
    'service:smsc-services',
    {
        'service_code': SERVICE_CODE,
        'host': HOSTNAME,
        'status': 'up'
        }
    )

# EOF
