#!/usr/bin/env python
# encoding: utf-8


"""
Command Line Interface
"""

from ..amqp_worker import Worker
from .. import consts
from . import app

import click
import pika


@click.group()
def cmd():
    pass


@cmd.command()
@click.option('--queue')
@click.option('--count', type=int, default=1)
def runworkers(queue, count):
    """Lance un ou plusieurs workers pour une ou plusieurs files d'attentes"""

    connection = pika.BlockingConnection(
        pika.ConnectionParameters(
            host='localhost',
            virtual_host='/smsc'
            )
        )

    channel = connection.channel()

    channel.exchange_declare(exchange='sendsms', exchange_type='topic')

    for smpp_account in consts.SMPP_ACCOUNTS:
        channel.queue_declare(queue=smpp_account, durable=True)
        channel.queue_bind(exchange='sendsms', queue=smpp_account)

    connection.close()

    if not queue:
        threads = [
            Worker('worker-{}-{}'.format(smpp_account, index), smpp_account)
            for smpp_account in consts.SMPP_ACCOUNTS
            for index in range(count)
            ]
    else:
        threads = [
            Worker('worker-{}-{}'.format(queue, index), queue)
            for index in range(count)
            ]
    for thread in threads:
        thread.start()


@cmd.command()
@click.option('--host', default='127.0.0.1')
@click.option('--port', default=5000)
def runserver(host, port):
    app.run(host=host, port=port, debug=True)


if __name__ == '__main__':
    cmd()

# EOF
