#!/usr/bin/env python
# encoding: utf-8


from spyne import Application
from spyne.protocol.soap import Soap11
from spyne.server.wsgi import WsgiApplication

from ...gateway import SoapPayload
from .app import FoamService


# Création de l'application WSGI pour SOAP

application = Application(
    [
        FoamService
        ],
    tns='api.blueline.mg',
    name='Foam',
    in_protocol=Soap11(),
    out_protocol=Soap11()
    )

application.event_manager.add_listener('method_call', SoapPayload.on_reception)
app = WsgiApplication(application)
