# to_log

Parce qu'on sait tous que ce n'est pas tout le monde qui fait du log, alors on a créé to_log.

## Installation

```shell
$ pip3 install -i http://miroir.blueline.mg/pypi to_log
```

## Utilisation

C'est genre, trop simple:
 
```python
>>> from to_log import Logger
>>> mylogger = Logger('mon_logger', level='DEBUG')
>>> mylogger.add_file_handler(
...     '/tmp/mylog.log',
...     level='INFO',
...     fmt='%(name)s "%(levelname)s %(funcName)s" %(message)s',
...     datefmt='%d-%m-%Y %H:%M:%S'
...     )
```

Dans l'exemple ci-dessus, `mylogger` aura deux `handlers`:

 - un, par défaut, qui écrira sur /dev/null
 
 - un autre, qui écrira dans `/tmp/mylog.log` au niveau `INFO` avec le format
   `'%(name)s "%(levelname)s %(funcName)s" %(message)s'`
   
> Pour remplacer le logger par défaut, il suffit d'utiliser `set_file_handler` au lieu de `add_file_handler`

> Le niveau de votre `logger` doit toujours être supérieur ou égal à celui de tous vos handlers

Et si jamais vous voulez que votre logger envoie plutôt le tout vers `syslog` (POSIX style), et bah:

```python
>>> from to_log import Logger
>>> mylogger = Logger('mon_logger')
>>> mylogger.set_syslog_handler()
```

On n'avait pas dit que c'était facile? Ah? Ok, bah c'est facile.
