# -*- coding: utf-8 -*-

"""
Ce module propose d'utiliser le module logging
de python de façon très intuitive.

On peut encore l'améliorer
"""

import logging


FORMAT = '[%(asctime)s] [%(levelname)s] [%(name)s] [%(funcName)s] %(message)s'
DATEFORMAT = '%Y-%m-%d %H:%M:%S %z'
DEFAULT_LEVEL = logging.DEBUG

__version__ = '0.2'


class Logger(object):

    def __init__(self, name, level=None):

        logger = logging.getLogger(name)
        level = Logger.level(level)
        logger.setLevel(level)

        self.logger = logger

    def __configure_handler__(self, handler, **kwargs):

        level = Logger.level(kwargs.get('level'))
        fmt = kwargs.get('fmt', FORMAT)
        datefmt = kwargs.get('datefmt', DATEFORMAT)
        formatter = logging.Formatter(fmt=fmt, datefmt=datefmt)
        handler.setLevel(level)
        handler.setFormatter(formatter)
        return handler

    @staticmethod
    def level(name=None):
        name = name or 'DEBUG'
        try:
            level = getattr(logging, name)
        except AttributeError:
            raise ValueError('Niveau de log inconnu: "{}"'.format(name))
        else:
            return level

    def add_file_handler(self, filename, **kwargs):
        handler = logging.FileHandler(filename=filename)
        handler = self.__configure_handler__(handler, **kwargs)
        self.logger.addHandler(handler)

    def set_file_handler(self, filename, **kwargs):
        handler = logging.FileHandler(filename=filename)
        handler = self.__configure_handler__(handler, **kwargs)
        self.logger.handlers = [handler]

    def add_syslog_handler(self, **kwargs):
        handler = logging.SysLogHandler(
            address='/dev/log',
            facility=logging.SysLogHandler.LOG_LOCAL0
            )
        handler = self.__configure_handler__(handler, **kwargs)
        self.logger.addHandler(handler)

    def set_syslog_handler(self, **kwargs):
        handler = logging.SysLogHandler(
            address='/dev/log',
            facility=logging.SysLogHandler.LOG_LOCAL0
            )
        handler = self.__configure_handler__(handler, **kwargs)
        self.logger.handlers = [handler]
# EOF
