#!/usr/bin/env python
# encoding: utf-8

from to_log import Logger # NOQA

import configparser
import socket

import pika
import redis

# utiliser rabbitmq pour la gestion des requêtes
# en asynchrone

connection = pika.BlockingConnection(
    pika.ConnectionParameters(
        host='localhost',
        virtual_host='/ussd'
        )
    )
# definition du channel et de l'exchange à utiliser sur rabbitmq
channel = connection.channel()
channel.exchange_declare(
    exchange='ussd_offer',
    exchange_type='topic'
    )
# definition du queue
channel.queue_declare(
    queue='activate.ussd',
    durable='True'
    )
# definition bind
channel.queue_bind(
    exchange='ussd_offer',
    queue='activate.ussd',
    routing_key='ussd_msg'
    )
connection.close()

CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/ussd-services/ussd-services.conf')

SERVICE_CODE = CONFIG['APP']['service_code']
GUNICORN_PORT = int(SERVICE_CODE[1:].replace('-', ''))
HOSTNAME = socket.gethostname().split('.')[0]
API_REGISTRY = redis.Redis(db=15)
if HOSTNAME.startswith('blpr'):
    API_REGISTRY = redis.Redis(host='api.blueline.mg', db=15)

LOG_FILE = CONFIG['LOGS']['filename']
LOG_LEVEL = CONFIG['LOGS']['level']

LOGS = Logger('ussd-services')
LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

API_LOGS = Logger('ussd-services-api')
API_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

BLUEFLASK_LOGS = Logger('blueflask')
BLUEFLASK_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

REST_CLIENT_LOGS = Logger('rest_client')
REST_CLIENT_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

# EOF
