#!/usr/local/bin python
# encoding: utf8
from blueflask.flask_api import FlaskApp

from .v1 import api
from .v1 import __version__
from .. import API_REGISTRY
from .. import LOGS
from .. import GUNICORN_PORT
from .. import HOSTNAME
from .. import SERVICE_CODE

flask_app = FlaskApp(SERVICE_CODE)
flask_app.produce_handlers_and_documentation()


app = flask_app.app
app.config['LOGGER_NAME'] = 'ussd-services-api'
app.config['TITLE'] = 'API USSD'
app.config['DESCRIPTION'] = "Communications avec l'USSD"
app.config['VERSION'] = __version__
app.logger.handlers = LOGS.logger.handlers
app.register_blueprint(api)


API_REGISTRY.hmset(
    'service:ussd-services',
    {
        'service_code': SERVICE_CODE,
        'host': HOSTNAME,
        'port': GUNICORN_PORT,
        'status': 'up'
        }
    )

# EOF
