# -*- encoding: utf-8 -*-

import xmltodict
from zeep import Client
from . import BLUEBASE
from . import PAYLOAD
from . import LOGS


class Merchant:

    def __init__(self, refnum=None):
        self.refnum = refnum
        self.wsdl = BLUEBASE["wsdl"]
        self.client = Client(self.wsdl)

    def all(self):
        PAYLOAD["root"]["header"]["param1"] = "client_rev_list"
        bluebase_client = self.client
        response = bluebase_client.service.S4D(xmltodict.unparse(PAYLOAD))
        response = xmltodict.parse(response)
        if response['root']['header'].get("errorNum") == '0':
            status = 200
            data = response['root']['data']["revendeur"]
        else:
            status = 500
            data = None
        response = {
            "status": status,
            "data": data,
            "code": "040-05-{}".format(status),
        }
        LOGS.logger.info(
            "Demande liste marchand: {}".format(response)
        )
        return response

    def infos(self):
        PAYLOAD["root"]["header"]["param1"] = "client_detail"
        data = {
            "client_refnum": self.refnum
        }
        PAYLOAD["root"]["data"] = data
        bluebase_client = self.client
        try:
            response = bluebase_client.service.S4D(xmltodict.unparse(PAYLOAD))
        except Exception:
            data = None
            status = 500
        else:
            response = xmltodict.parse(response)
            if response['root']['header'].get("errorNum") == "0":
                data = response["root"]["data"]["client"]
                status = 200
            else:
                data = None
                status = 500
        response = {
            "status": status,
            "data": data,
            "code": "040-05-{}".format(status),
        }
        LOGS.logger.info(
            "Demande infos marchand: {}".format(response)
        )
        return response

# EOF
