#!/usr/local/bin python
# encoding: utf8

from blueflask.flask_api import FlaskApp

from .. import ADDRESS
from .. import APIGW
from .. import LOGS
from .. import HOSTNAME
from .. import SERVICE_CODE
from .v1 import api
from .v1 import __version__

import requests


flask_app = FlaskApp(SERVICE_CODE)
flask_app.produce_handlers_and_documentation()

app = flask_app.app
app.config["LOGGER_NAME"] = "ussd-services-api"
app.config["TITLE"] = "API USSD"
app.config["DESCRIPTION"] = "Communications avec l'USSD"
app.config["VERSION"] = __version__
app.logger.handlers = LOGS.logger.handlers
app.register_blueprint(api)

requests.post(
    "https://{fqdn}/registry".format(fqdn=APIGW),
    json={
        "service": "ussd",
        "version": int(eval(__version__)),
        "address": ADDRESS,
        "service_code": SERVICE_CODE,
        "host": HOSTNAME,
        "status": "up",
    },
)


if __name__ == "__main__":
    app.run(debug=True)
# EOF
